/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.accounts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateApiKeyRequestBody {
    private final Optional<String> description;
    private final Optional<String> environmentId;
    private final String name;
    private final Map<String, Object> additionalProperties;

    private CreateApiKeyRequestBody(Optional<String> description, Optional<String> environmentId, String name, Map<String, Object> additionalProperties) {
        this.description = description;
        this.environmentId = environmentId;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="environment_id")
    public Optional<String> getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateApiKeyRequestBody && this.equalTo((CreateApiKeyRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateApiKeyRequestBody other) {
        return this.description.equals(other.description) && this.environmentId.equals(other.environmentId) && this.name.equals(other.name);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.environmentId, this.name);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NameStage,
    _FinalStage {
        private String name;
        private Optional<String> environmentId = Optional.empty();
        private Optional<String> description = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateApiKeyRequestBody other) {
            this.description(other.getDescription());
            this.environmentId(other.getEnvironmentId());
            this.name(other.getName());
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @Override
        @JsonSetter(value="environment_id", nulls=Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public CreateApiKeyRequestBody build() {
            return new CreateApiKeyRequestBody(this.description, this.environmentId, this.name, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateApiKeyRequestBody build();

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage environmentId(Optional<String> var1);

        public _FinalStage environmentId(String var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);

        public Builder from(CreateApiKeyRequestBody var1);
    }
}

