/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.accounts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListApiKeysRequest {
    private final Optional<String> environmentId;
    private final boolean requireEnvironment;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private ListApiKeysRequest(Optional<String> environmentId, boolean requireEnvironment, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.environmentId = environmentId;
        this.requireEnvironment = requireEnvironment;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="environment_id")
    public Optional<String> getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="require_environment")
    public boolean getRequireEnvironment() {
        return this.requireEnvironment;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListApiKeysRequest && this.equalTo((ListApiKeysRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListApiKeysRequest other) {
        return this.environmentId.equals(other.environmentId) && this.requireEnvironment == other.requireEnvironment && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.environmentId, this.requireEnvironment, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RequireEnvironmentStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements RequireEnvironmentStage,
    _FinalStage {
        private boolean requireEnvironment;
        private Optional<Integer> offset = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> environmentId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListApiKeysRequest other) {
            this.environmentId(other.getEnvironmentId());
            this.requireEnvironment(other.getRequireEnvironment());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @Override
        @JsonSetter(value="require_environment")
        public _FinalStage requireEnvironment(boolean requireEnvironment) {
            this.requireEnvironment = requireEnvironment;
            return this;
        }

        @Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @Override
        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @Override
        @JsonSetter(value="environment_id", nulls=Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public ListApiKeysRequest build() {
            return new ListApiKeysRequest(this.environmentId, this.requireEnvironment, this.limit, this.offset, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListApiKeysRequest build();

        public _FinalStage environmentId(Optional<String> var1);

        public _FinalStage environmentId(String var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage offset(Optional<Integer> var1);

        public _FinalStage offset(Integer var1);
    }

    public static interface RequireEnvironmentStage {
        public _FinalStage requireEnvironment(boolean var1);

        public Builder from(ListApiKeysRequest var1);
    }
}

