/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.billing.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListInvoicesRequest {
    private final Optional<String> companyId;
    private final String customerExternalId;
    private final Optional<String> subscriptionExternalId;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private ListInvoicesRequest(Optional<String> companyId, String customerExternalId, Optional<String> subscriptionExternalId, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.customerExternalId = customerExternalId;
        this.subscriptionExternalId = subscriptionExternalId;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="customer_external_id")
    public String getCustomerExternalId() {
        return this.customerExternalId;
    }

    @JsonProperty(value="subscription_external_id")
    public Optional<String> getSubscriptionExternalId() {
        return this.subscriptionExternalId;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListInvoicesRequest && this.equalTo((ListInvoicesRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListInvoicesRequest other) {
        return this.companyId.equals(other.companyId) && this.customerExternalId.equals(other.customerExternalId) && this.subscriptionExternalId.equals(other.subscriptionExternalId) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.customerExternalId, this.subscriptionExternalId, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CustomerExternalIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CustomerExternalIdStage,
    _FinalStage {
        private String customerExternalId;
        private Optional<Integer> offset = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<String> subscriptionExternalId = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ListInvoicesRequest other) {
            this.companyId(other.getCompanyId());
            this.customerExternalId(other.getCustomerExternalId());
            this.subscriptionExternalId(other.getSubscriptionExternalId());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @Override
        @JsonSetter(value="customer_external_id")
        public _FinalStage customerExternalId(@NotNull String customerExternalId) {
            this.customerExternalId = Objects.requireNonNull(customerExternalId, "customerExternalId must not be null");
            return this;
        }

        @Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @Override
        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public _FinalStage subscriptionExternalId(String subscriptionExternalId) {
            this.subscriptionExternalId = Optional.ofNullable(subscriptionExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="subscription_external_id", nulls=Nulls.SKIP)
        public _FinalStage subscriptionExternalId(Optional<String> subscriptionExternalId) {
            this.subscriptionExternalId = subscriptionExternalId;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public ListInvoicesRequest build() {
            return new ListInvoicesRequest(this.companyId, this.customerExternalId, this.subscriptionExternalId, this.limit, this.offset, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ListInvoicesRequest build();

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage subscriptionExternalId(Optional<String> var1);

        public _FinalStage subscriptionExternalId(String var1);

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage offset(Optional<Integer> var1);

        public _FinalStage offset(Integer var1);
    }

    public static interface CustomerExternalIdStage {
        public _FinalStage customerExternalId(@NotNull String var1);

        public Builder from(ListInvoicesRequest var1);
    }
}

