/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class GetActiveDealsRequest {
    private final String companyId;
    private final String dealStage;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private GetActiveDealsRequest(String companyId, String dealStage, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.dealStage = dealStage;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="deal_stage")
    public String getDealStage() {
        return this.dealStage;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof GetActiveDealsRequest && this.equalTo((GetActiveDealsRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetActiveDealsRequest other) {
        return this.companyId.equals(other.companyId) && this.dealStage.equals(other.dealStage) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.dealStage, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    DealStageStage,
    _FinalStage {
        private String companyId;
        private String dealStage;
        private Optional<Integer> offset = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(GetActiveDealsRequest other) {
            this.companyId(other.getCompanyId());
            this.dealStage(other.getDealStage());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public DealStageStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="deal_stage")
        public _FinalStage dealStage(@NotNull String dealStage) {
            this.dealStage = Objects.requireNonNull(dealStage, "dealStage must not be null");
            return this;
        }

        @Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @Override
        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @Override
        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public GetActiveDealsRequest build() {
            return new GetActiveDealsRequest(this.companyId, this.dealStage, this.limit, this.offset, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public GetActiveDealsRequest build();

        public _FinalStage limit(Optional<Integer> var1);

        public _FinalStage limit(Integer var1);

        public _FinalStage offset(Optional<Integer> var1);

        public _FinalStage offset(Integer var1);
    }

    public static interface DealStageStage {
        public _FinalStage dealStage(@NotNull String var1);
    }

    public static interface CompanyIdStage {
        public DealStageStage companyId(@NotNull String var1);

        public Builder from(GetActiveDealsRequest var1);
    }
}

