/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListCompanyMembershipsParams {
    private final Optional<String> companyId;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<String> userId;
    private final Map<String, Object> additionalProperties;

    private ListCompanyMembershipsParams(Optional<String> companyId, Optional<Integer> limit, Optional<Integer> offset, Optional<String> userId, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.limit = limit;
        this.offset = offset;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListCompanyMembershipsParams && this.equalTo((ListCompanyMembershipsParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCompanyMembershipsParams other) {
        return this.companyId.equals(other.companyId) && this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.userId.equals(other.userId);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.limit, this.offset, this.userId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<String> userId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListCompanyMembershipsParams other) {
            this.companyId(other.getCompanyId());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.userId(other.getUserId());
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public Builder userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        public Builder userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        public ListCompanyMembershipsParams build() {
            return new ListCompanyMembershipsParams(this.companyId, this.limit, this.offset, this.userId, this.additionalProperties);
        }
    }
}

