/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.components.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PreviewComponentDataRequest {
    private final Optional<String> companyId;
    private final Optional<String> componentId;
    private final Map<String, Object> additionalProperties;

    private PreviewComponentDataRequest(Optional<String> companyId, Optional<String> componentId, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.componentId = componentId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="component_id")
    public Optional<String> getComponentId() {
        return this.componentId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PreviewComponentDataRequest && this.equalTo((PreviewComponentDataRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewComponentDataRequest other) {
        return this.companyId.equals(other.companyId) && this.componentId.equals(other.componentId);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.componentId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();
        private Optional<String> componentId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(PreviewComponentDataRequest other) {
            this.companyId(other.getCompanyId());
            this.componentId(other.getComponentId());
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="component_id", nulls=Nulls.SKIP)
        public Builder componentId(Optional<String> componentId) {
            this.componentId = componentId;
            return this;
        }

        public Builder componentId(String componentId) {
            this.componentId = Optional.ofNullable(componentId);
            return this;
        }

        public PreviewComponentDataRequest build() {
            return new PreviewComponentDataRequest(this.companyId, this.componentId, this.additionalProperties);
        }
    }
}

