/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.crm.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CreateCrmProductRequestBody {
    private final String currency;
    private final String description;
    private final String externalId;
    private final String interval;
    private final String name;
    private final String price;
    private final int quantity;
    private final String sku;
    private final Map<String, Object> additionalProperties;

    private CreateCrmProductRequestBody(String currency, String description, String externalId, String interval, String name, String price, int quantity, String sku, Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.description = description;
        this.externalId = externalId;
        this.interval = interval;
        this.name = name;
        this.price = price;
        this.quantity = quantity;
        this.sku = sku;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="price")
    public String getPrice() {
        return this.price;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="sku")
    public String getSku() {
        return this.sku;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CreateCrmProductRequestBody && this.equalTo((CreateCrmProductRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCrmProductRequestBody other) {
        return this.currency.equals(other.currency) && this.description.equals(other.description) && this.externalId.equals(other.externalId) && this.interval.equals(other.interval) && this.name.equals(other.name) && this.price.equals(other.price) && this.quantity == other.quantity && this.sku.equals(other.sku);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.description, this.externalId, this.interval, this.name, this.price, this.quantity, this.sku);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CurrencyStage,
    DescriptionStage,
    ExternalIdStage,
    IntervalStage,
    NameStage,
    PriceStage,
    QuantityStage,
    SkuStage,
    _FinalStage {
        private String currency;
        private String description;
        private String externalId;
        private String interval;
        private String name;
        private String price;
        private int quantity;
        private String sku;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CreateCrmProductRequestBody other) {
            this.currency(other.getCurrency());
            this.description(other.getDescription());
            this.externalId(other.getExternalId());
            this.interval(other.getInterval());
            this.name(other.getName());
            this.price(other.getPrice());
            this.quantity(other.getQuantity());
            this.sku(other.getSku());
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public DescriptionStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public ExternalIdStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public IntervalStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public NameStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public QuantityStage price(@NotNull String price) {
            this.price = Objects.requireNonNull(price, "price must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public SkuStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="sku")
        public _FinalStage sku(@NotNull String sku) {
            this.sku = Objects.requireNonNull(sku, "sku must not be null");
            return this;
        }

        @Override
        public CreateCrmProductRequestBody build() {
            return new CreateCrmProductRequestBody(this.currency, this.description, this.externalId, this.interval, this.name, this.price, this.quantity, this.sku, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CreateCrmProductRequestBody build();
    }

    public static interface SkuStage {
        public _FinalStage sku(@NotNull String var1);
    }

    public static interface QuantityStage {
        public SkuStage quantity(int var1);
    }

    public static interface PriceStage {
        public QuantityStage price(@NotNull String var1);
    }

    public static interface NameStage {
        public PriceStage name(@NotNull String var1);
    }

    public static interface IntervalStage {
        public NameStage interval(@NotNull String var1);
    }

    public static interface ExternalIdStage {
        public IntervalStage externalId(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public ExternalIdStage description(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public DescriptionStage currency(@NotNull String var1);

        public Builder from(CreateCrmProductRequestBody var1);
    }
}

