/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.plans.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.plans.types.ListPlansRequestPlanType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ListPlansRequest {
    private final Optional<String> companyId;
    private final Optional<Boolean> hasProductId;
    private final Optional<String> ids;
    private final Optional<ListPlansRequestPlanType> planType;
    private final Optional<String> q;
    private final Optional<String> withoutEntitlementFor;
    private final Optional<Boolean> withoutProductId;
    private final Optional<Boolean> withoutPaidProductId;
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Map<String, Object> additionalProperties;

    private ListPlansRequest(Optional<String> companyId, Optional<Boolean> hasProductId, Optional<String> ids, Optional<ListPlansRequestPlanType> planType, Optional<String> q, Optional<String> withoutEntitlementFor, Optional<Boolean> withoutProductId, Optional<Boolean> withoutPaidProductId, Optional<Integer> limit, Optional<Integer> offset, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.hasProductId = hasProductId;
        this.ids = ids;
        this.planType = planType;
        this.q = q;
        this.withoutEntitlementFor = withoutEntitlementFor;
        this.withoutProductId = withoutProductId;
        this.withoutPaidProductId = withoutPaidProductId;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="has_product_id")
    public Optional<Boolean> getHasProductId() {
        return this.hasProductId;
    }

    @JsonProperty(value="ids")
    public Optional<String> getIds() {
        return this.ids;
    }

    @JsonProperty(value="plan_type")
    public Optional<ListPlansRequestPlanType> getPlanType() {
        return this.planType;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    @JsonProperty(value="without_entitlement_for")
    public Optional<String> getWithoutEntitlementFor() {
        return this.withoutEntitlementFor;
    }

    @JsonProperty(value="without_product_id")
    public Optional<Boolean> getWithoutProductId() {
        return this.withoutProductId;
    }

    @JsonProperty(value="without_paid_product_id")
    public Optional<Boolean> getWithoutPaidProductId() {
        return this.withoutPaidProductId;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ListPlansRequest && this.equalTo((ListPlansRequest)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListPlansRequest other) {
        return this.companyId.equals(other.companyId) && this.hasProductId.equals(other.hasProductId) && this.ids.equals(other.ids) && this.planType.equals(other.planType) && this.q.equals(other.q) && this.withoutEntitlementFor.equals(other.withoutEntitlementFor) && this.withoutProductId.equals(other.withoutProductId) && this.withoutPaidProductId.equals(other.withoutPaidProductId) && this.limit.equals(other.limit) && this.offset.equals(other.offset);
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.hasProductId, this.ids, this.planType, this.q, this.withoutEntitlementFor, this.withoutProductId, this.withoutPaidProductId, this.limit, this.offset);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();
        private Optional<Boolean> hasProductId = Optional.empty();
        private Optional<String> ids = Optional.empty();
        private Optional<ListPlansRequestPlanType> planType = Optional.empty();
        private Optional<String> q = Optional.empty();
        private Optional<String> withoutEntitlementFor = Optional.empty();
        private Optional<Boolean> withoutProductId = Optional.empty();
        private Optional<Boolean> withoutPaidProductId = Optional.empty();
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ListPlansRequest other) {
            this.companyId(other.getCompanyId());
            this.hasProductId(other.getHasProductId());
            this.ids(other.getIds());
            this.planType(other.getPlanType());
            this.q(other.getQ());
            this.withoutEntitlementFor(other.getWithoutEntitlementFor());
            this.withoutProductId(other.getWithoutProductId());
            this.withoutPaidProductId(other.getWithoutPaidProductId());
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            return this;
        }

        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value="has_product_id", nulls=Nulls.SKIP)
        public Builder hasProductId(Optional<Boolean> hasProductId) {
            this.hasProductId = hasProductId;
            return this;
        }

        public Builder hasProductId(Boolean hasProductId) {
            this.hasProductId = Optional.ofNullable(hasProductId);
            return this;
        }

        @JsonSetter(value="ids", nulls=Nulls.SKIP)
        public Builder ids(Optional<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value="plan_type", nulls=Nulls.SKIP)
        public Builder planType(Optional<ListPlansRequestPlanType> planType) {
            this.planType = planType;
            return this;
        }

        public Builder planType(ListPlansRequestPlanType planType) {
            this.planType = Optional.ofNullable(planType);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value="without_entitlement_for", nulls=Nulls.SKIP)
        public Builder withoutEntitlementFor(Optional<String> withoutEntitlementFor) {
            this.withoutEntitlementFor = withoutEntitlementFor;
            return this;
        }

        public Builder withoutEntitlementFor(String withoutEntitlementFor) {
            this.withoutEntitlementFor = Optional.ofNullable(withoutEntitlementFor);
            return this;
        }

        @JsonSetter(value="without_product_id", nulls=Nulls.SKIP)
        public Builder withoutProductId(Optional<Boolean> withoutProductId) {
            this.withoutProductId = withoutProductId;
            return this;
        }

        public Builder withoutProductId(Boolean withoutProductId) {
            this.withoutProductId = Optional.ofNullable(withoutProductId);
            return this;
        }

        @JsonSetter(value="without_paid_product_id", nulls=Nulls.SKIP)
        public Builder withoutPaidProductId(Optional<Boolean> withoutPaidProductId) {
            this.withoutPaidProductId = withoutPaidProductId;
            return this;
        }

        public Builder withoutPaidProductId(Boolean withoutPaidProductId) {
            this.withoutPaidProductId = Optional.ofNullable(withoutPaidProductId);
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListPlansRequest build() {
            return new ListPlansRequest(this.companyId, this.hasProductId, this.ids, this.planType, this.q, this.withoutEntitlementFor, this.withoutProductId, this.withoutPaidProductId, this.limit, this.offset, this.additionalProperties);
        }
    }
}

