/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.resources.webhooks.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CountWebhooksParams {
    private final Optional<Integer> limit;
    private final Optional<Integer> offset;
    private final Optional<String> q;
    private final Map<String, Object> additionalProperties;

    private CountWebhooksParams(Optional<Integer> limit, Optional<Integer> offset, Optional<String> q, Map<String, Object> additionalProperties) {
        this.limit = limit;
        this.offset = offset;
        this.q = q;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="limit")
    public Optional<Integer> getLimit() {
        return this.limit;
    }

    @JsonProperty(value="offset")
    public Optional<Integer> getOffset() {
        return this.offset;
    }

    @JsonProperty(value="q")
    public Optional<String> getQ() {
        return this.q;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CountWebhooksParams && this.equalTo((CountWebhooksParams)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountWebhooksParams other) {
        return this.limit.equals(other.limit) && this.offset.equals(other.offset) && this.q.equals(other.q);
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.offset, this.q);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<Integer> limit = Optional.empty();
        private Optional<Integer> offset = Optional.empty();
        private Optional<String> q = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CountWebhooksParams other) {
            this.limit(other.getLimit());
            this.offset(other.getOffset());
            this.q(other.getQ());
            return this;
        }

        @JsonSetter(value="limit", nulls=Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value="offset", nulls=Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value="q", nulls=Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        public CountWebhooksParams build() {
            return new CountWebhooksParams(this.limit, this.offset, this.q, this.additionalProperties);
        }
    }
}

