/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ApiKeyRequestResponseData {
    private final String apiKeyId;
    private final Optional<OffsetDateTime> endedAt;
    private final Optional<String> environmentId;
    private final String id;
    private final String method;
    private final Optional<String> reqBody;
    private final Optional<String> requestType;
    private final Optional<Integer> resourceId;
    private final Optional<String> resourceIdString;
    private final Optional<String> resourceName;
    private final Optional<String> resourceType;
    private final Optional<String> respBody;
    private final Optional<Integer> respCode;
    private final Optional<String> secondaryResource;
    private final OffsetDateTime startedAt;
    private final String url;
    private final Optional<String> userAgent;
    private final Optional<String> userId;
    private final Optional<String> userName;
    private final Map<String, Object> additionalProperties;

    private ApiKeyRequestResponseData(String apiKeyId, Optional<OffsetDateTime> endedAt, Optional<String> environmentId, String id, String method, Optional<String> reqBody, Optional<String> requestType, Optional<Integer> resourceId, Optional<String> resourceIdString, Optional<String> resourceName, Optional<String> resourceType, Optional<String> respBody, Optional<Integer> respCode, Optional<String> secondaryResource, OffsetDateTime startedAt, String url, Optional<String> userAgent, Optional<String> userId, Optional<String> userName, Map<String, Object> additionalProperties) {
        this.apiKeyId = apiKeyId;
        this.endedAt = endedAt;
        this.environmentId = environmentId;
        this.id = id;
        this.method = method;
        this.reqBody = reqBody;
        this.requestType = requestType;
        this.resourceId = resourceId;
        this.resourceIdString = resourceIdString;
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.respBody = respBody;
        this.respCode = respCode;
        this.secondaryResource = secondaryResource;
        this.startedAt = startedAt;
        this.url = url;
        this.userAgent = userAgent;
        this.userId = userId;
        this.userName = userName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="api_key_id")
    public String getApiKeyId() {
        return this.apiKeyId;
    }

    @JsonProperty(value="ended_at")
    public Optional<OffsetDateTime> getEndedAt() {
        return this.endedAt;
    }

    @JsonProperty(value="environment_id")
    public Optional<String> getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="method")
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="req_body")
    public Optional<String> getReqBody() {
        return this.reqBody;
    }

    @JsonProperty(value="request_type")
    public Optional<String> getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="resource_id")
    public Optional<Integer> getResourceId() {
        return this.resourceId;
    }

    @JsonProperty(value="resource_id_string")
    public Optional<String> getResourceIdString() {
        return this.resourceIdString;
    }

    @JsonProperty(value="resource_name")
    public Optional<String> getResourceName() {
        return this.resourceName;
    }

    @JsonProperty(value="resource_type")
    public Optional<String> getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="resp_body")
    public Optional<String> getRespBody() {
        return this.respBody;
    }

    @JsonProperty(value="resp_code")
    public Optional<Integer> getRespCode() {
        return this.respCode;
    }

    @JsonProperty(value="secondary_resource")
    public Optional<String> getSecondaryResource() {
        return this.secondaryResource;
    }

    @JsonProperty(value="started_at")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="user_agent")
    public Optional<String> getUserAgent() {
        return this.userAgent;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="user_name")
    public Optional<String> getUserName() {
        return this.userName;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ApiKeyRequestResponseData && this.equalTo((ApiKeyRequestResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ApiKeyRequestResponseData other) {
        return this.apiKeyId.equals(other.apiKeyId) && this.endedAt.equals(other.endedAt) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.method.equals(other.method) && this.reqBody.equals(other.reqBody) && this.requestType.equals(other.requestType) && this.resourceId.equals(other.resourceId) && this.resourceIdString.equals(other.resourceIdString) && this.resourceName.equals(other.resourceName) && this.resourceType.equals(other.resourceType) && this.respBody.equals(other.respBody) && this.respCode.equals(other.respCode) && this.secondaryResource.equals(other.secondaryResource) && this.startedAt.equals(other.startedAt) && this.url.equals(other.url) && this.userAgent.equals(other.userAgent) && this.userId.equals(other.userId) && this.userName.equals(other.userName);
    }

    public int hashCode() {
        return Objects.hash(this.apiKeyId, this.endedAt, this.environmentId, this.id, this.method, this.reqBody, this.requestType, this.resourceId, this.resourceIdString, this.resourceName, this.resourceType, this.respBody, this.respCode, this.secondaryResource, this.startedAt, this.url, this.userAgent, this.userId, this.userName);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ApiKeyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ApiKeyIdStage,
    IdStage,
    MethodStage,
    StartedAtStage,
    UrlStage,
    _FinalStage {
        private String apiKeyId;
        private String id;
        private String method;
        private OffsetDateTime startedAt;
        private String url;
        private Optional<String> userName = Optional.empty();
        private Optional<String> userId = Optional.empty();
        private Optional<String> userAgent = Optional.empty();
        private Optional<String> secondaryResource = Optional.empty();
        private Optional<Integer> respCode = Optional.empty();
        private Optional<String> respBody = Optional.empty();
        private Optional<String> resourceType = Optional.empty();
        private Optional<String> resourceName = Optional.empty();
        private Optional<String> resourceIdString = Optional.empty();
        private Optional<Integer> resourceId = Optional.empty();
        private Optional<String> requestType = Optional.empty();
        private Optional<String> reqBody = Optional.empty();
        private Optional<String> environmentId = Optional.empty();
        private Optional<OffsetDateTime> endedAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ApiKeyRequestResponseData other) {
            this.apiKeyId(other.getApiKeyId());
            this.endedAt(other.getEndedAt());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.method(other.getMethod());
            this.reqBody(other.getReqBody());
            this.requestType(other.getRequestType());
            this.resourceId(other.getResourceId());
            this.resourceIdString(other.getResourceIdString());
            this.resourceName(other.getResourceName());
            this.resourceType(other.getResourceType());
            this.respBody(other.getRespBody());
            this.respCode(other.getRespCode());
            this.secondaryResource(other.getSecondaryResource());
            this.startedAt(other.getStartedAt());
            this.url(other.getUrl());
            this.userAgent(other.getUserAgent());
            this.userId(other.getUserId());
            this.userName(other.getUserName());
            return this;
        }

        @Override
        @JsonSetter(value="api_key_id")
        public IdStage apiKeyId(@NotNull String apiKeyId) {
            this.apiKeyId = Objects.requireNonNull(apiKeyId, "apiKeyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public MethodStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="method")
        public StartedAtStage method(@NotNull String method) {
            this.method = Objects.requireNonNull(method, "method must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="started_at")
        public UrlStage startedAt(@NotNull OffsetDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @Override
        public _FinalStage userName(String userName) {
            this.userName = Optional.ofNullable(userName);
            return this;
        }

        @Override
        @JsonSetter(value="user_name", nulls=Nulls.SKIP)
        public _FinalStage userName(Optional<String> userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public _FinalStage userAgent(String userAgent) {
            this.userAgent = Optional.ofNullable(userAgent);
            return this;
        }

        @Override
        @JsonSetter(value="user_agent", nulls=Nulls.SKIP)
        public _FinalStage userAgent(Optional<String> userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Override
        public _FinalStage secondaryResource(String secondaryResource) {
            this.secondaryResource = Optional.ofNullable(secondaryResource);
            return this;
        }

        @Override
        @JsonSetter(value="secondary_resource", nulls=Nulls.SKIP)
        public _FinalStage secondaryResource(Optional<String> secondaryResource) {
            this.secondaryResource = secondaryResource;
            return this;
        }

        @Override
        public _FinalStage respCode(Integer respCode) {
            this.respCode = Optional.ofNullable(respCode);
            return this;
        }

        @Override
        @JsonSetter(value="resp_code", nulls=Nulls.SKIP)
        public _FinalStage respCode(Optional<Integer> respCode) {
            this.respCode = respCode;
            return this;
        }

        @Override
        public _FinalStage respBody(String respBody) {
            this.respBody = Optional.ofNullable(respBody);
            return this;
        }

        @Override
        @JsonSetter(value="resp_body", nulls=Nulls.SKIP)
        public _FinalStage respBody(Optional<String> respBody) {
            this.respBody = respBody;
            return this;
        }

        @Override
        public _FinalStage resourceType(String resourceType) {
            this.resourceType = Optional.ofNullable(resourceType);
            return this;
        }

        @Override
        @JsonSetter(value="resource_type", nulls=Nulls.SKIP)
        public _FinalStage resourceType(Optional<String> resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public _FinalStage resourceName(String resourceName) {
            this.resourceName = Optional.ofNullable(resourceName);
            return this;
        }

        @Override
        @JsonSetter(value="resource_name", nulls=Nulls.SKIP)
        public _FinalStage resourceName(Optional<String> resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public _FinalStage resourceIdString(String resourceIdString) {
            this.resourceIdString = Optional.ofNullable(resourceIdString);
            return this;
        }

        @Override
        @JsonSetter(value="resource_id_string", nulls=Nulls.SKIP)
        public _FinalStage resourceIdString(Optional<String> resourceIdString) {
            this.resourceIdString = resourceIdString;
            return this;
        }

        @Override
        public _FinalStage resourceId(Integer resourceId) {
            this.resourceId = Optional.ofNullable(resourceId);
            return this;
        }

        @Override
        @JsonSetter(value="resource_id", nulls=Nulls.SKIP)
        public _FinalStage resourceId(Optional<Integer> resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public _FinalStage requestType(String requestType) {
            this.requestType = Optional.ofNullable(requestType);
            return this;
        }

        @Override
        @JsonSetter(value="request_type", nulls=Nulls.SKIP)
        public _FinalStage requestType(Optional<String> requestType) {
            this.requestType = requestType;
            return this;
        }

        @Override
        public _FinalStage reqBody(String reqBody) {
            this.reqBody = Optional.ofNullable(reqBody);
            return this;
        }

        @Override
        @JsonSetter(value="req_body", nulls=Nulls.SKIP)
        public _FinalStage reqBody(Optional<String> reqBody) {
            this.reqBody = reqBody;
            return this;
        }

        @Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @Override
        @JsonSetter(value="environment_id", nulls=Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public _FinalStage endedAt(OffsetDateTime endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        @Override
        @JsonSetter(value="ended_at", nulls=Nulls.SKIP)
        public _FinalStage endedAt(Optional<OffsetDateTime> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public ApiKeyRequestResponseData build() {
            return new ApiKeyRequestResponseData(this.apiKeyId, this.endedAt, this.environmentId, this.id, this.method, this.reqBody, this.requestType, this.resourceId, this.resourceIdString, this.resourceName, this.resourceType, this.respBody, this.respCode, this.secondaryResource, this.startedAt, this.url, this.userAgent, this.userId, this.userName, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ApiKeyRequestResponseData build();

        public _FinalStage endedAt(Optional<OffsetDateTime> var1);

        public _FinalStage endedAt(OffsetDateTime var1);

        public _FinalStage environmentId(Optional<String> var1);

        public _FinalStage environmentId(String var1);

        public _FinalStage reqBody(Optional<String> var1);

        public _FinalStage reqBody(String var1);

        public _FinalStage requestType(Optional<String> var1);

        public _FinalStage requestType(String var1);

        public _FinalStage resourceId(Optional<Integer> var1);

        public _FinalStage resourceId(Integer var1);

        public _FinalStage resourceIdString(Optional<String> var1);

        public _FinalStage resourceIdString(String var1);

        public _FinalStage resourceName(Optional<String> var1);

        public _FinalStage resourceName(String var1);

        public _FinalStage resourceType(Optional<String> var1);

        public _FinalStage resourceType(String var1);

        public _FinalStage respBody(Optional<String> var1);

        public _FinalStage respBody(String var1);

        public _FinalStage respCode(Optional<Integer> var1);

        public _FinalStage respCode(Integer var1);

        public _FinalStage secondaryResource(Optional<String> var1);

        public _FinalStage secondaryResource(String var1);

        public _FinalStage userAgent(Optional<String> var1);

        public _FinalStage userAgent(String var1);

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);

        public _FinalStage userName(Optional<String> var1);

        public _FinalStage userName(String var1);
    }

    public static interface UrlStage {
        public _FinalStage url(@NotNull String var1);
    }

    public static interface StartedAtStage {
        public UrlStage startedAt(@NotNull OffsetDateTime var1);
    }

    public static interface MethodStage {
        public StartedAtStage method(@NotNull String var1);
    }

    public static interface IdStage {
        public MethodStage id(@NotNull String var1);
    }

    public static interface ApiKeyIdStage {
        public IdStage apiKeyId(@NotNull String var1);

        public Builder from(ApiKeyRequestResponseData var1);
    }
}

