/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingMeterResponseData {
    private final String dispalyName;
    private final String eventName;
    private final String eventPayloadKey;
    private final String externalPriceId;
    private final String id;
    private final Map<String, Object> additionalProperties;

    private BillingMeterResponseData(String dispalyName, String eventName, String eventPayloadKey, String externalPriceId, String id, Map<String, Object> additionalProperties) {
        this.dispalyName = dispalyName;
        this.eventName = eventName;
        this.eventPayloadKey = eventPayloadKey;
        this.externalPriceId = externalPriceId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="dispaly_name")
    public String getDispalyName() {
        return this.dispalyName;
    }

    @JsonProperty(value="event_name")
    public String getEventName() {
        return this.eventName;
    }

    @JsonProperty(value="event_payload_key")
    public String getEventPayloadKey() {
        return this.eventPayloadKey;
    }

    @JsonProperty(value="external_price_id")
    public String getExternalPriceId() {
        return this.externalPriceId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingMeterResponseData && this.equalTo((BillingMeterResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingMeterResponseData other) {
        return this.dispalyName.equals(other.dispalyName) && this.eventName.equals(other.eventName) && this.eventPayloadKey.equals(other.eventPayloadKey) && this.externalPriceId.equals(other.externalPriceId) && this.id.equals(other.id);
    }

    public int hashCode() {
        return Objects.hash(this.dispalyName, this.eventName, this.eventPayloadKey, this.externalPriceId, this.id);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DispalyNameStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements DispalyNameStage,
    EventNameStage,
    EventPayloadKeyStage,
    ExternalPriceIdStage,
    IdStage,
    _FinalStage {
        private String dispalyName;
        private String eventName;
        private String eventPayloadKey;
        private String externalPriceId;
        private String id;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingMeterResponseData other) {
            this.dispalyName(other.getDispalyName());
            this.eventName(other.getEventName());
            this.eventPayloadKey(other.getEventPayloadKey());
            this.externalPriceId(other.getExternalPriceId());
            this.id(other.getId());
            return this;
        }

        @Override
        @JsonSetter(value="dispaly_name")
        public EventNameStage dispalyName(@NotNull String dispalyName) {
            this.dispalyName = Objects.requireNonNull(dispalyName, "dispalyName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_name")
        public EventPayloadKeyStage eventName(@NotNull String eventName) {
            this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_payload_key")
        public ExternalPriceIdStage eventPayloadKey(@NotNull String eventPayloadKey) {
            this.eventPayloadKey = Objects.requireNonNull(eventPayloadKey, "eventPayloadKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_price_id")
        public IdStage externalPriceId(@NotNull String externalPriceId) {
            this.externalPriceId = Objects.requireNonNull(externalPriceId, "externalPriceId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public BillingMeterResponseData build() {
            return new BillingMeterResponseData(this.dispalyName, this.eventName, this.eventPayloadKey, this.externalPriceId, this.id, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingMeterResponseData build();
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);
    }

    public static interface ExternalPriceIdStage {
        public IdStage externalPriceId(@NotNull String var1);
    }

    public static interface EventPayloadKeyStage {
        public ExternalPriceIdStage eventPayloadKey(@NotNull String var1);
    }

    public static interface EventNameStage {
        public EventPayloadKeyStage eventName(@NotNull String var1);
    }

    public static interface DispalyNameStage {
        public EventNameStage dispalyName(@NotNull String var1);

        public Builder from(BillingMeterResponseData var1);
    }
}

