/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingProductPlanResponseData {
    private final String accountId;
    private final String billingProductId;
    private final String environmentId;
    private final boolean isTrialable;
    private final Optional<String> monthlyPriceId;
    private final String planId;
    private final Optional<Integer> trialDays;
    private final Optional<String> yearlyPriceId;
    private final Map<String, Object> additionalProperties;

    private BillingProductPlanResponseData(String accountId, String billingProductId, String environmentId, boolean isTrialable, Optional<String> monthlyPriceId, String planId, Optional<Integer> trialDays, Optional<String> yearlyPriceId, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.billingProductId = billingProductId;
        this.environmentId = environmentId;
        this.isTrialable = isTrialable;
        this.monthlyPriceId = monthlyPriceId;
        this.planId = planId;
        this.trialDays = trialDays;
        this.yearlyPriceId = yearlyPriceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="billing_product_id")
    public String getBillingProductId() {
        return this.billingProductId;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="is_trialable")
    public boolean getIsTrialable() {
        return this.isTrialable;
    }

    @JsonProperty(value="monthly_price_id")
    public Optional<String> getMonthlyPriceId() {
        return this.monthlyPriceId;
    }

    @JsonProperty(value="plan_id")
    public String getPlanId() {
        return this.planId;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="yearly_price_id")
    public Optional<String> getYearlyPriceId() {
        return this.yearlyPriceId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingProductPlanResponseData && this.equalTo((BillingProductPlanResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductPlanResponseData other) {
        return this.accountId.equals(other.accountId) && this.billingProductId.equals(other.billingProductId) && this.environmentId.equals(other.environmentId) && this.isTrialable == other.isTrialable && this.monthlyPriceId.equals(other.monthlyPriceId) && this.planId.equals(other.planId) && this.trialDays.equals(other.trialDays) && this.yearlyPriceId.equals(other.yearlyPriceId);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.billingProductId, this.environmentId, this.isTrialable, this.monthlyPriceId, this.planId, this.trialDays, this.yearlyPriceId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    BillingProductIdStage,
    EnvironmentIdStage,
    IsTrialableStage,
    PlanIdStage,
    _FinalStage {
        private String accountId;
        private String billingProductId;
        private String environmentId;
        private boolean isTrialable;
        private String planId;
        private Optional<String> yearlyPriceId = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<String> monthlyPriceId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingProductPlanResponseData other) {
            this.accountId(other.getAccountId());
            this.billingProductId(other.getBillingProductId());
            this.environmentId(other.getEnvironmentId());
            this.isTrialable(other.getIsTrialable());
            this.monthlyPriceId(other.getMonthlyPriceId());
            this.planId(other.getPlanId());
            this.trialDays(other.getTrialDays());
            this.yearlyPriceId(other.getYearlyPriceId());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public BillingProductIdStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="billing_product_id")
        public EnvironmentIdStage billingProductId(@NotNull String billingProductId) {
            this.billingProductId = Objects.requireNonNull(billingProductId, "billingProductId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IsTrialableStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_trialable")
        public PlanIdStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @Override
        @JsonSetter(value="plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @Override
        public _FinalStage yearlyPriceId(String yearlyPriceId) {
            this.yearlyPriceId = Optional.ofNullable(yearlyPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_price_id", nulls=Nulls.SKIP)
        public _FinalStage yearlyPriceId(Optional<String> yearlyPriceId) {
            this.yearlyPriceId = yearlyPriceId;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage monthlyPriceId(String monthlyPriceId) {
            this.monthlyPriceId = Optional.ofNullable(monthlyPriceId);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_price_id", nulls=Nulls.SKIP)
        public _FinalStage monthlyPriceId(Optional<String> monthlyPriceId) {
            this.monthlyPriceId = monthlyPriceId;
            return this;
        }

        @Override
        public BillingProductPlanResponseData build() {
            return new BillingProductPlanResponseData(this.accountId, this.billingProductId, this.environmentId, this.isTrialable, this.monthlyPriceId, this.planId, this.trialDays, this.yearlyPriceId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingProductPlanResponseData build();

        public _FinalStage monthlyPriceId(Optional<String> var1);

        public _FinalStage monthlyPriceId(String var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage yearlyPriceId(Optional<String> var1);

        public _FinalStage yearlyPriceId(String var1);
    }

    public static interface PlanIdStage {
        public _FinalStage planId(@NotNull String var1);
    }

    public static interface IsTrialableStage {
        public PlanIdStage isTrialable(boolean var1);
    }

    public static interface EnvironmentIdStage {
        public IsTrialableStage environmentId(@NotNull String var1);
    }

    public static interface BillingProductIdStage {
        public EnvironmentIdStage billingProductId(@NotNull String var1);
    }

    public static interface AccountIdStage {
        public BillingProductIdStage accountId(@NotNull String var1);

        public Builder from(BillingProductPlanResponseData var1);
    }
}

