/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingProductPricing {
    private final String currency;
    private final String interval;
    private final Optional<String> meterId;
    private final int price;
    private final String priceExternalId;
    private final String productExternalId;
    private final int quantity;
    private final String usageType;
    private final Map<String, Object> additionalProperties;

    private BillingProductPricing(String currency, String interval, Optional<String> meterId, int price, String priceExternalId, String productExternalId, int quantity, String usageType, Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.interval = interval;
        this.meterId = meterId;
        this.price = price;
        this.priceExternalId = priceExternalId;
        this.productExternalId = productExternalId;
        this.quantity = quantity;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    @JsonProperty(value="meter_id")
    public Optional<String> getMeterId() {
        return this.meterId;
    }

    @JsonProperty(value="price")
    public int getPrice() {
        return this.price;
    }

    @JsonProperty(value="price_external_id")
    public String getPriceExternalId() {
        return this.priceExternalId;
    }

    @JsonProperty(value="product_external_id")
    public String getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="usage_type")
    public String getUsageType() {
        return this.usageType;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingProductPricing && this.equalTo((BillingProductPricing)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductPricing other) {
        return this.currency.equals(other.currency) && this.interval.equals(other.interval) && this.meterId.equals(other.meterId) && this.price == other.price && this.priceExternalId.equals(other.priceExternalId) && this.productExternalId.equals(other.productExternalId) && this.quantity == other.quantity && this.usageType.equals(other.usageType);
    }

    public int hashCode() {
        return Objects.hash(this.currency, this.interval, this.meterId, this.price, this.priceExternalId, this.productExternalId, this.quantity, this.usageType);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CurrencyStage,
    IntervalStage,
    PriceStage,
    PriceExternalIdStage,
    ProductExternalIdStage,
    QuantityStage,
    UsageTypeStage,
    _FinalStage {
        private String currency;
        private String interval;
        private int price;
        private String priceExternalId;
        private String productExternalId;
        private int quantity;
        private String usageType;
        private Optional<String> meterId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingProductPricing other) {
            this.currency(other.getCurrency());
            this.interval(other.getInterval());
            this.meterId(other.getMeterId());
            this.price(other.getPrice());
            this.priceExternalId(other.getPriceExternalId());
            this.productExternalId(other.getProductExternalId());
            this.quantity(other.getQuantity());
            this.usageType(other.getUsageType());
            return this;
        }

        @Override
        @JsonSetter(value="currency")
        public IntervalStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="interval")
        public PriceStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @Override
        @JsonSetter(value="price_external_id")
        public ProductExternalIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id")
        public QuantityStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public UsageTypeStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="usage_type")
        public _FinalStage usageType(@NotNull String usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @Override
        @JsonSetter(value="meter_id", nulls=Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @Override
        public BillingProductPricing build() {
            return new BillingProductPricing(this.currency, this.interval, this.meterId, this.price, this.priceExternalId, this.productExternalId, this.quantity, this.usageType, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingProductPricing build();

        public _FinalStage meterId(Optional<String> var1);

        public _FinalStage meterId(String var1);
    }

    public static interface UsageTypeStage {
        public _FinalStage usageType(@NotNull String var1);
    }

    public static interface QuantityStage {
        public UsageTypeStage quantity(int var1);
    }

    public static interface ProductExternalIdStage {
        public QuantityStage productExternalId(@NotNull String var1);
    }

    public static interface PriceExternalIdStage {
        public ProductExternalIdStage priceExternalId(@NotNull String var1);
    }

    public static interface PriceStage {
        public PriceExternalIdStage price(int var1);
    }

    public static interface IntervalStage {
        public PriceStage interval(@NotNull String var1);
    }

    public static interface CurrencyStage {
        public IntervalStage currency(@NotNull String var1);

        public Builder from(BillingProductPricing var1);
    }
}

