/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class BillingSubscriptionDiscount {
    private final String couponExternalId;
    private final Optional<String> customerFacingCode;
    private final Optional<OffsetDateTime> endedAt;
    private final String externalId;
    private final boolean isActive;
    private final Optional<String> promoCodeExternalId;
    private final OffsetDateTime startedAt;
    private final Map<String, Object> additionalProperties;

    private BillingSubscriptionDiscount(String couponExternalId, Optional<String> customerFacingCode, Optional<OffsetDateTime> endedAt, String externalId, boolean isActive, Optional<String> promoCodeExternalId, OffsetDateTime startedAt, Map<String, Object> additionalProperties) {
        this.couponExternalId = couponExternalId;
        this.customerFacingCode = customerFacingCode;
        this.endedAt = endedAt;
        this.externalId = externalId;
        this.isActive = isActive;
        this.promoCodeExternalId = promoCodeExternalId;
        this.startedAt = startedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="coupon_external_id")
    public String getCouponExternalId() {
        return this.couponExternalId;
    }

    @JsonProperty(value="customer_facing_code")
    public Optional<String> getCustomerFacingCode() {
        return this.customerFacingCode;
    }

    @JsonProperty(value="ended_at")
    public Optional<OffsetDateTime> getEndedAt() {
        return this.endedAt;
    }

    @JsonProperty(value="external_id")
    public String getExternalId() {
        return this.externalId;
    }

    @JsonProperty(value="is_active")
    public boolean getIsActive() {
        return this.isActive;
    }

    @JsonProperty(value="promo_code_external_id")
    public Optional<String> getPromoCodeExternalId() {
        return this.promoCodeExternalId;
    }

    @JsonProperty(value="started_at")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof BillingSubscriptionDiscount && this.equalTo((BillingSubscriptionDiscount)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingSubscriptionDiscount other) {
        return this.couponExternalId.equals(other.couponExternalId) && this.customerFacingCode.equals(other.customerFacingCode) && this.endedAt.equals(other.endedAt) && this.externalId.equals(other.externalId) && this.isActive == other.isActive && this.promoCodeExternalId.equals(other.promoCodeExternalId) && this.startedAt.equals(other.startedAt);
    }

    public int hashCode() {
        return Objects.hash(this.couponExternalId, this.customerFacingCode, this.endedAt, this.externalId, this.isActive, this.promoCodeExternalId, this.startedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CouponExternalIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CouponExternalIdStage,
    ExternalIdStage,
    IsActiveStage,
    StartedAtStage,
    _FinalStage {
        private String couponExternalId;
        private String externalId;
        private boolean isActive;
        private OffsetDateTime startedAt;
        private Optional<String> promoCodeExternalId = Optional.empty();
        private Optional<OffsetDateTime> endedAt = Optional.empty();
        private Optional<String> customerFacingCode = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(BillingSubscriptionDiscount other) {
            this.couponExternalId(other.getCouponExternalId());
            this.customerFacingCode(other.getCustomerFacingCode());
            this.endedAt(other.getEndedAt());
            this.externalId(other.getExternalId());
            this.isActive(other.getIsActive());
            this.promoCodeExternalId(other.getPromoCodeExternalId());
            this.startedAt(other.getStartedAt());
            return this;
        }

        @Override
        @JsonSetter(value="coupon_external_id")
        public ExternalIdStage couponExternalId(@NotNull String couponExternalId) {
            this.couponExternalId = Objects.requireNonNull(couponExternalId, "couponExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="external_id")
        public IsActiveStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_active")
        public StartedAtStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @Override
        @JsonSetter(value="started_at")
        public _FinalStage startedAt(@NotNull OffsetDateTime startedAt) {
            this.startedAt = Objects.requireNonNull(startedAt, "startedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage promoCodeExternalId(String promoCodeExternalId) {
            this.promoCodeExternalId = Optional.ofNullable(promoCodeExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="promo_code_external_id", nulls=Nulls.SKIP)
        public _FinalStage promoCodeExternalId(Optional<String> promoCodeExternalId) {
            this.promoCodeExternalId = promoCodeExternalId;
            return this;
        }

        @Override
        public _FinalStage endedAt(OffsetDateTime endedAt) {
            this.endedAt = Optional.ofNullable(endedAt);
            return this;
        }

        @Override
        @JsonSetter(value="ended_at", nulls=Nulls.SKIP)
        public _FinalStage endedAt(Optional<OffsetDateTime> endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        @Override
        public _FinalStage customerFacingCode(String customerFacingCode) {
            this.customerFacingCode = Optional.ofNullable(customerFacingCode);
            return this;
        }

        @Override
        @JsonSetter(value="customer_facing_code", nulls=Nulls.SKIP)
        public _FinalStage customerFacingCode(Optional<String> customerFacingCode) {
            this.customerFacingCode = customerFacingCode;
            return this;
        }

        @Override
        public BillingSubscriptionDiscount build() {
            return new BillingSubscriptionDiscount(this.couponExternalId, this.customerFacingCode, this.endedAt, this.externalId, this.isActive, this.promoCodeExternalId, this.startedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public BillingSubscriptionDiscount build();

        public _FinalStage customerFacingCode(Optional<String> var1);

        public _FinalStage customerFacingCode(String var1);

        public _FinalStage endedAt(Optional<OffsetDateTime> var1);

        public _FinalStage endedAt(OffsetDateTime var1);

        public _FinalStage promoCodeExternalId(Optional<String> var1);

        public _FinalStage promoCodeExternalId(String var1);
    }

    public static interface StartedAtStage {
        public _FinalStage startedAt(@NotNull OffsetDateTime var1);
    }

    public static interface IsActiveStage {
        public StartedAtStage isActive(boolean var1);
    }

    public static interface ExternalIdStage {
        public IsActiveStage externalId(@NotNull String var1);
    }

    public static interface CouponExternalIdStage {
        public ExternalIdStage couponExternalId(@NotNull String var1);

        public Builder from(BillingSubscriptionDiscount var1);
    }
}

