/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.UpdateAddOnRequestBody;
import com.schematic.api.types.UpdatePayInAdvanceRequestBody;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ChangeSubscriptionRequestBody {
    private final List<UpdateAddOnRequestBody> addOnIds;
    private final String newPlanId;
    private final String newPriceId;
    private final List<UpdatePayInAdvanceRequestBody> payInAdvance;
    private final Optional<String> paymentMethodId;
    private final Optional<String> promoCode;
    private final Map<String, Object> additionalProperties;

    private ChangeSubscriptionRequestBody(List<UpdateAddOnRequestBody> addOnIds, String newPlanId, String newPriceId, List<UpdatePayInAdvanceRequestBody> payInAdvance, Optional<String> paymentMethodId, Optional<String> promoCode, Map<String, Object> additionalProperties) {
        this.addOnIds = addOnIds;
        this.newPlanId = newPlanId;
        this.newPriceId = newPriceId;
        this.payInAdvance = payInAdvance;
        this.paymentMethodId = paymentMethodId;
        this.promoCode = promoCode;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_on_ids")
    public List<UpdateAddOnRequestBody> getAddOnIds() {
        return this.addOnIds;
    }

    @JsonProperty(value="new_plan_id")
    public String getNewPlanId() {
        return this.newPlanId;
    }

    @JsonProperty(value="new_price_id")
    public String getNewPriceId() {
        return this.newPriceId;
    }

    @JsonProperty(value="pay_in_advance")
    public List<UpdatePayInAdvanceRequestBody> getPayInAdvance() {
        return this.payInAdvance;
    }

    @JsonProperty(value="payment_method_id")
    public Optional<String> getPaymentMethodId() {
        return this.paymentMethodId;
    }

    @JsonProperty(value="promo_code")
    public Optional<String> getPromoCode() {
        return this.promoCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ChangeSubscriptionRequestBody && this.equalTo((ChangeSubscriptionRequestBody)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ChangeSubscriptionRequestBody other) {
        return this.addOnIds.equals(other.addOnIds) && this.newPlanId.equals(other.newPlanId) && this.newPriceId.equals(other.newPriceId) && this.payInAdvance.equals(other.payInAdvance) && this.paymentMethodId.equals(other.paymentMethodId) && this.promoCode.equals(other.promoCode);
    }

    public int hashCode() {
        return Objects.hash(this.addOnIds, this.newPlanId, this.newPriceId, this.payInAdvance, this.paymentMethodId, this.promoCode);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NewPlanIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements NewPlanIdStage,
    NewPriceIdStage,
    _FinalStage {
        private String newPlanId;
        private String newPriceId;
        private Optional<String> promoCode = Optional.empty();
        private Optional<String> paymentMethodId = Optional.empty();
        private List<UpdatePayInAdvanceRequestBody> payInAdvance = new ArrayList<UpdatePayInAdvanceRequestBody>();
        private List<UpdateAddOnRequestBody> addOnIds = new ArrayList<UpdateAddOnRequestBody>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ChangeSubscriptionRequestBody other) {
            this.addOnIds(other.getAddOnIds());
            this.newPlanId(other.getNewPlanId());
            this.newPriceId(other.getNewPriceId());
            this.payInAdvance(other.getPayInAdvance());
            this.paymentMethodId(other.getPaymentMethodId());
            this.promoCode(other.getPromoCode());
            return this;
        }

        @Override
        @JsonSetter(value="new_plan_id")
        public NewPriceIdStage newPlanId(@NotNull String newPlanId) {
            this.newPlanId = Objects.requireNonNull(newPlanId, "newPlanId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="new_price_id")
        public _FinalStage newPriceId(@NotNull String newPriceId) {
            this.newPriceId = Objects.requireNonNull(newPriceId, "newPriceId must not be null");
            return this;
        }

        @Override
        public _FinalStage promoCode(String promoCode) {
            this.promoCode = Optional.ofNullable(promoCode);
            return this;
        }

        @Override
        @JsonSetter(value="promo_code", nulls=Nulls.SKIP)
        public _FinalStage promoCode(Optional<String> promoCode) {
            this.promoCode = promoCode;
            return this;
        }

        @Override
        public _FinalStage paymentMethodId(String paymentMethodId) {
            this.paymentMethodId = Optional.ofNullable(paymentMethodId);
            return this;
        }

        @Override
        @JsonSetter(value="payment_method_id", nulls=Nulls.SKIP)
        public _FinalStage paymentMethodId(Optional<String> paymentMethodId) {
            this.paymentMethodId = paymentMethodId;
            return this;
        }

        @Override
        public _FinalStage addAllPayInAdvance(List<UpdatePayInAdvanceRequestBody> payInAdvance) {
            this.payInAdvance.addAll(payInAdvance);
            return this;
        }

        @Override
        public _FinalStage addPayInAdvance(UpdatePayInAdvanceRequestBody payInAdvance) {
            this.payInAdvance.add(payInAdvance);
            return this;
        }

        @Override
        @JsonSetter(value="pay_in_advance", nulls=Nulls.SKIP)
        public _FinalStage payInAdvance(List<UpdatePayInAdvanceRequestBody> payInAdvance) {
            this.payInAdvance.clear();
            this.payInAdvance.addAll(payInAdvance);
            return this;
        }

        @Override
        public _FinalStage addAllAddOnIds(List<UpdateAddOnRequestBody> addOnIds) {
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @Override
        public _FinalStage addAddOnIds(UpdateAddOnRequestBody addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        @Override
        @JsonSetter(value="add_on_ids", nulls=Nulls.SKIP)
        public _FinalStage addOnIds(List<UpdateAddOnRequestBody> addOnIds) {
            this.addOnIds.clear();
            this.addOnIds.addAll(addOnIds);
            return this;
        }

        @Override
        public ChangeSubscriptionRequestBody build() {
            return new ChangeSubscriptionRequestBody(this.addOnIds, this.newPlanId, this.newPriceId, this.payInAdvance, this.paymentMethodId, this.promoCode, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ChangeSubscriptionRequestBody build();

        public _FinalStage addOnIds(List<UpdateAddOnRequestBody> var1);

        public _FinalStage addAddOnIds(UpdateAddOnRequestBody var1);

        public _FinalStage addAllAddOnIds(List<UpdateAddOnRequestBody> var1);

        public _FinalStage payInAdvance(List<UpdatePayInAdvanceRequestBody> var1);

        public _FinalStage addPayInAdvance(UpdatePayInAdvanceRequestBody var1);

        public _FinalStage addAllPayInAdvance(List<UpdatePayInAdvanceRequestBody> var1);

        public _FinalStage paymentMethodId(Optional<String> var1);

        public _FinalStage paymentMethodId(String var1);

        public _FinalStage promoCode(Optional<String> var1);

        public _FinalStage promoCode(String var1);
    }

    public static interface NewPriceIdStage {
        public _FinalStage newPriceId(@NotNull String var1);
    }

    public static interface NewPlanIdStage {
        public NewPriceIdStage newPlanId(@NotNull String var1);

        public Builder from(ChangeSubscriptionRequestBody var1);
    }
}

