/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CompanyDetailResponseData;
import com.schematic.api.types.CompanySubscriptionResponseData;
import com.schematic.api.types.FeatureUsageDetailResponseData;
import com.schematic.api.types.PlanDetailResponseData;
import com.schematic.api.types.UsageBasedEntitlementResponseData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CheckoutDataResponseData {
    private final List<PlanDetailResponseData> activeAddOns;
    private final Optional<PlanDetailResponseData> activePlan;
    private final List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements;
    private final Optional<CompanyDetailResponseData> company;
    private final Optional<FeatureUsageDetailResponseData> featureUsage;
    private final Optional<CompanySubscriptionResponseData> subscription;
    private final Map<String, Object> additionalProperties;

    private CheckoutDataResponseData(List<PlanDetailResponseData> activeAddOns, Optional<PlanDetailResponseData> activePlan, List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements, Optional<CompanyDetailResponseData> company, Optional<FeatureUsageDetailResponseData> featureUsage, Optional<CompanySubscriptionResponseData> subscription, Map<String, Object> additionalProperties) {
        this.activeAddOns = activeAddOns;
        this.activePlan = activePlan;
        this.activeUsageBasedEntitlements = activeUsageBasedEntitlements;
        this.company = company;
        this.featureUsage = featureUsage;
        this.subscription = subscription;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="active_add_ons")
    public List<PlanDetailResponseData> getActiveAddOns() {
        return this.activeAddOns;
    }

    @JsonProperty(value="active_plan")
    public Optional<PlanDetailResponseData> getActivePlan() {
        return this.activePlan;
    }

    @JsonProperty(value="active_usage_based_entitlements")
    public List<UsageBasedEntitlementResponseData> getActiveUsageBasedEntitlements() {
        return this.activeUsageBasedEntitlements;
    }

    @JsonProperty(value="company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="feature_usage")
    public Optional<FeatureUsageDetailResponseData> getFeatureUsage() {
        return this.featureUsage;
    }

    @JsonProperty(value="subscription")
    public Optional<CompanySubscriptionResponseData> getSubscription() {
        return this.subscription;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CheckoutDataResponseData && this.equalTo((CheckoutDataResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CheckoutDataResponseData other) {
        return this.activeAddOns.equals(other.activeAddOns) && this.activePlan.equals(other.activePlan) && this.activeUsageBasedEntitlements.equals(other.activeUsageBasedEntitlements) && this.company.equals(other.company) && this.featureUsage.equals(other.featureUsage) && this.subscription.equals(other.subscription);
    }

    public int hashCode() {
        return Objects.hash(this.activeAddOns, this.activePlan, this.activeUsageBasedEntitlements, this.company, this.featureUsage, this.subscription);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<PlanDetailResponseData> activeAddOns = new ArrayList<PlanDetailResponseData>();
        private Optional<PlanDetailResponseData> activePlan = Optional.empty();
        private List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements = new ArrayList<UsageBasedEntitlementResponseData>();
        private Optional<CompanyDetailResponseData> company = Optional.empty();
        private Optional<FeatureUsageDetailResponseData> featureUsage = Optional.empty();
        private Optional<CompanySubscriptionResponseData> subscription = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(CheckoutDataResponseData other) {
            this.activeAddOns(other.getActiveAddOns());
            this.activePlan(other.getActivePlan());
            this.activeUsageBasedEntitlements(other.getActiveUsageBasedEntitlements());
            this.company(other.getCompany());
            this.featureUsage(other.getFeatureUsage());
            this.subscription(other.getSubscription());
            return this;
        }

        @JsonSetter(value="active_add_ons", nulls=Nulls.SKIP)
        public Builder activeAddOns(List<PlanDetailResponseData> activeAddOns) {
            this.activeAddOns.clear();
            this.activeAddOns.addAll(activeAddOns);
            return this;
        }

        public Builder addActiveAddOns(PlanDetailResponseData activeAddOns) {
            this.activeAddOns.add(activeAddOns);
            return this;
        }

        public Builder addAllActiveAddOns(List<PlanDetailResponseData> activeAddOns) {
            this.activeAddOns.addAll(activeAddOns);
            return this;
        }

        @JsonSetter(value="active_plan", nulls=Nulls.SKIP)
        public Builder activePlan(Optional<PlanDetailResponseData> activePlan) {
            this.activePlan = activePlan;
            return this;
        }

        public Builder activePlan(PlanDetailResponseData activePlan) {
            this.activePlan = Optional.ofNullable(activePlan);
            return this;
        }

        @JsonSetter(value="active_usage_based_entitlements", nulls=Nulls.SKIP)
        public Builder activeUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.clear();
            this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            return this;
        }

        public Builder addActiveUsageBasedEntitlements(UsageBasedEntitlementResponseData activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.add(activeUsageBasedEntitlements);
            return this;
        }

        public Builder addAllActiveUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        public Builder company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @JsonSetter(value="feature_usage", nulls=Nulls.SKIP)
        public Builder featureUsage(Optional<FeatureUsageDetailResponseData> featureUsage) {
            this.featureUsage = featureUsage;
            return this;
        }

        public Builder featureUsage(FeatureUsageDetailResponseData featureUsage) {
            this.featureUsage = Optional.ofNullable(featureUsage);
            return this;
        }

        @JsonSetter(value="subscription", nulls=Nulls.SKIP)
        public Builder subscription(Optional<CompanySubscriptionResponseData> subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder subscription(CompanySubscriptionResponseData subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        public CheckoutDataResponseData build() {
            return new CheckoutDataResponseData(this.activeAddOns, this.activePlan, this.activeUsageBasedEntitlements, this.company, this.featureUsage, this.subscription, this.additionalProperties);
        }
    }
}

