/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingSubscriptionView;
import com.schematic.api.types.CompanyEventPeriodMetricsResponseData;
import com.schematic.api.types.CompanyPlanWithBillingSubView;
import com.schematic.api.types.EntityKeyDetailResponseData;
import com.schematic.api.types.EntityTraitDetailResponseData;
import com.schematic.api.types.GenericPreviewObject;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyDetailResponseData {
    private final List<CompanyPlanWithBillingSubView> addOns;
    private final Optional<BillingSubscriptionView> billingSubscription;
    private final List<BillingSubscriptionView> billingSubscriptions;
    private final OffsetDateTime createdAt;
    private final List<EntityTraitDetailResponseData> entityTraits;
    private final String environmentId;
    private final String id;
    private final List<EntityKeyDetailResponseData> keys;
    private final Optional<OffsetDateTime> lastSeenAt;
    private final Optional<String> logoUrl;
    private final List<CompanyEventPeriodMetricsResponseData> metrics;
    private final String name;
    private final Optional<CompanyPlanWithBillingSubView> plan;
    private final List<GenericPreviewObject> plans;
    private final Optional<Map<String, JsonNode>> traits;
    private final OffsetDateTime updatedAt;
    private final int userCount;
    private final Map<String, Object> additionalProperties;

    private CompanyDetailResponseData(List<CompanyPlanWithBillingSubView> addOns, Optional<BillingSubscriptionView> billingSubscription, List<BillingSubscriptionView> billingSubscriptions, OffsetDateTime createdAt, List<EntityTraitDetailResponseData> entityTraits, String environmentId, String id, List<EntityKeyDetailResponseData> keys, Optional<OffsetDateTime> lastSeenAt, Optional<String> logoUrl, List<CompanyEventPeriodMetricsResponseData> metrics, String name, Optional<CompanyPlanWithBillingSubView> plan, List<GenericPreviewObject> plans, Optional<Map<String, JsonNode>> traits, OffsetDateTime updatedAt, int userCount, Map<String, Object> additionalProperties) {
        this.addOns = addOns;
        this.billingSubscription = billingSubscription;
        this.billingSubscriptions = billingSubscriptions;
        this.createdAt = createdAt;
        this.entityTraits = entityTraits;
        this.environmentId = environmentId;
        this.id = id;
        this.keys = keys;
        this.lastSeenAt = lastSeenAt;
        this.logoUrl = logoUrl;
        this.metrics = metrics;
        this.name = name;
        this.plan = plan;
        this.plans = plans;
        this.traits = traits;
        this.updatedAt = updatedAt;
        this.userCount = userCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="add_ons")
    public List<CompanyPlanWithBillingSubView> getAddOns() {
        return this.addOns;
    }

    @JsonProperty(value="billing_subscription")
    public Optional<BillingSubscriptionView> getBillingSubscription() {
        return this.billingSubscription;
    }

    @JsonProperty(value="billing_subscriptions")
    public List<BillingSubscriptionView> getBillingSubscriptions() {
        return this.billingSubscriptions;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="entity_traits")
    public List<EntityTraitDetailResponseData> getEntityTraits() {
        return this.entityTraits;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="keys")
    public List<EntityKeyDetailResponseData> getKeys() {
        return this.keys;
    }

    @JsonProperty(value="last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @JsonProperty(value="logo_url")
    public Optional<String> getLogoUrl() {
        return this.logoUrl;
    }

    @JsonProperty(value="metrics")
    public List<CompanyEventPeriodMetricsResponseData> getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plan")
    public Optional<CompanyPlanWithBillingSubView> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="plans")
    public List<GenericPreviewObject> getPlans() {
        return this.plans;
    }

    @JsonProperty(value="traits")
    public Optional<Map<String, JsonNode>> getTraits() {
        return this.traits;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="user_count")
    public int getUserCount() {
        return this.userCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyDetailResponseData && this.equalTo((CompanyDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyDetailResponseData other) {
        return this.addOns.equals(other.addOns) && this.billingSubscription.equals(other.billingSubscription) && this.billingSubscriptions.equals(other.billingSubscriptions) && this.createdAt.equals(other.createdAt) && this.entityTraits.equals(other.entityTraits) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.keys.equals(other.keys) && this.lastSeenAt.equals(other.lastSeenAt) && this.logoUrl.equals(other.logoUrl) && this.metrics.equals(other.metrics) && this.name.equals(other.name) && this.plan.equals(other.plan) && this.plans.equals(other.plans) && this.traits.equals(other.traits) && this.updatedAt.equals(other.updatedAt) && this.userCount == other.userCount;
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.billingSubscription, this.billingSubscriptions, this.createdAt, this.entityTraits, this.environmentId, this.id, this.keys, this.lastSeenAt, this.logoUrl, this.metrics, this.name, this.plan, this.plans, this.traits, this.updatedAt, this.userCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    EnvironmentIdStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    UserCountStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String environmentId;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private int userCount;
        private Optional<Map<String, JsonNode>> traits = Optional.empty();
        private List<GenericPreviewObject> plans = new ArrayList<GenericPreviewObject>();
        private Optional<CompanyPlanWithBillingSubView> plan = Optional.empty();
        private List<CompanyEventPeriodMetricsResponseData> metrics = new ArrayList<CompanyEventPeriodMetricsResponseData>();
        private Optional<String> logoUrl = Optional.empty();
        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();
        private List<EntityKeyDetailResponseData> keys = new ArrayList<EntityKeyDetailResponseData>();
        private List<EntityTraitDetailResponseData> entityTraits = new ArrayList<EntityTraitDetailResponseData>();
        private List<BillingSubscriptionView> billingSubscriptions = new ArrayList<BillingSubscriptionView>();
        private Optional<BillingSubscriptionView> billingSubscription = Optional.empty();
        private List<CompanyPlanWithBillingSubView> addOns = new ArrayList<CompanyPlanWithBillingSubView>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyDetailResponseData other) {
            this.addOns(other.getAddOns());
            this.billingSubscription(other.getBillingSubscription());
            this.billingSubscriptions(other.getBillingSubscriptions());
            this.createdAt(other.getCreatedAt());
            this.entityTraits(other.getEntityTraits());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.keys(other.getKeys());
            this.lastSeenAt(other.getLastSeenAt());
            this.logoUrl(other.getLogoUrl());
            this.metrics(other.getMetrics());
            this.name(other.getName());
            this.plan(other.getPlan());
            this.plans(other.getPlans());
            this.traits(other.getTraits());
            this.updatedAt(other.getUpdatedAt());
            this.userCount(other.getUserCount());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public UserCountStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_count")
        public _FinalStage userCount(int userCount) {
            this.userCount = userCount;
            return this;
        }

        @Override
        public _FinalStage traits(Map<String, JsonNode> traits) {
            this.traits = Optional.ofNullable(traits);
            return this;
        }

        @Override
        @JsonSetter(value="traits", nulls=Nulls.SKIP)
        public _FinalStage traits(Optional<Map<String, JsonNode>> traits) {
            this.traits = traits;
            return this;
        }

        @Override
        public _FinalStage addAllPlans(List<GenericPreviewObject> plans) {
            this.plans.addAll(plans);
            return this;
        }

        @Override
        public _FinalStage addPlans(GenericPreviewObject plans) {
            this.plans.add(plans);
            return this;
        }

        @Override
        @JsonSetter(value="plans", nulls=Nulls.SKIP)
        public _FinalStage plans(List<GenericPreviewObject> plans) {
            this.plans.clear();
            this.plans.addAll(plans);
            return this;
        }

        @Override
        public _FinalStage plan(CompanyPlanWithBillingSubView plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @Override
        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public _FinalStage plan(Optional<CompanyPlanWithBillingSubView> plan) {
            this.plan = plan;
            return this;
        }

        @Override
        public _FinalStage addAllMetrics(List<CompanyEventPeriodMetricsResponseData> metrics) {
            this.metrics.addAll(metrics);
            return this;
        }

        @Override
        public _FinalStage addMetrics(CompanyEventPeriodMetricsResponseData metrics) {
            this.metrics.add(metrics);
            return this;
        }

        @Override
        @JsonSetter(value="metrics", nulls=Nulls.SKIP)
        public _FinalStage metrics(List<CompanyEventPeriodMetricsResponseData> metrics) {
            this.metrics.clear();
            this.metrics.addAll(metrics);
            return this;
        }

        @Override
        public _FinalStage logoUrl(String logoUrl) {
            this.logoUrl = Optional.ofNullable(logoUrl);
            return this;
        }

        @Override
        @JsonSetter(value="logo_url", nulls=Nulls.SKIP)
        public _FinalStage logoUrl(Optional<String> logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        @Override
        public _FinalStage lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @Override
        public _FinalStage addAllKeys(List<EntityKeyDetailResponseData> keys) {
            this.keys.addAll(keys);
            return this;
        }

        @Override
        public _FinalStage addKeys(EntityKeyDetailResponseData keys) {
            this.keys.add(keys);
            return this;
        }

        @Override
        @JsonSetter(value="keys", nulls=Nulls.SKIP)
        public _FinalStage keys(List<EntityKeyDetailResponseData> keys) {
            this.keys.clear();
            this.keys.addAll(keys);
            return this;
        }

        @Override
        public _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            this.entityTraits.addAll(entityTraits);
            return this;
        }

        @Override
        public _FinalStage addEntityTraits(EntityTraitDetailResponseData entityTraits) {
            this.entityTraits.add(entityTraits);
            return this;
        }

        @Override
        @JsonSetter(value="entity_traits", nulls=Nulls.SKIP)
        public _FinalStage entityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            this.entityTraits.clear();
            this.entityTraits.addAll(entityTraits);
            return this;
        }

        @Override
        public _FinalStage addAllBillingSubscriptions(List<BillingSubscriptionView> billingSubscriptions) {
            this.billingSubscriptions.addAll(billingSubscriptions);
            return this;
        }

        @Override
        public _FinalStage addBillingSubscriptions(BillingSubscriptionView billingSubscriptions) {
            this.billingSubscriptions.add(billingSubscriptions);
            return this;
        }

        @Override
        @JsonSetter(value="billing_subscriptions", nulls=Nulls.SKIP)
        public _FinalStage billingSubscriptions(List<BillingSubscriptionView> billingSubscriptions) {
            this.billingSubscriptions.clear();
            this.billingSubscriptions.addAll(billingSubscriptions);
            return this;
        }

        @Override
        public _FinalStage billingSubscription(BillingSubscriptionView billingSubscription) {
            this.billingSubscription = Optional.ofNullable(billingSubscription);
            return this;
        }

        @Override
        @JsonSetter(value="billing_subscription", nulls=Nulls.SKIP)
        public _FinalStage billingSubscription(Optional<BillingSubscriptionView> billingSubscription) {
            this.billingSubscription = billingSubscription;
            return this;
        }

        @Override
        public _FinalStage addAllAddOns(List<CompanyPlanWithBillingSubView> addOns) {
            this.addOns.addAll(addOns);
            return this;
        }

        @Override
        public _FinalStage addAddOns(CompanyPlanWithBillingSubView addOns) {
            this.addOns.add(addOns);
            return this;
        }

        @Override
        @JsonSetter(value="add_ons", nulls=Nulls.SKIP)
        public _FinalStage addOns(List<CompanyPlanWithBillingSubView> addOns) {
            this.addOns.clear();
            this.addOns.addAll(addOns);
            return this;
        }

        @Override
        public CompanyDetailResponseData build() {
            return new CompanyDetailResponseData(this.addOns, this.billingSubscription, this.billingSubscriptions, this.createdAt, this.entityTraits, this.environmentId, this.id, this.keys, this.lastSeenAt, this.logoUrl, this.metrics, this.name, this.plan, this.plans, this.traits, this.updatedAt, this.userCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyDetailResponseData build();

        public _FinalStage addOns(List<CompanyPlanWithBillingSubView> var1);

        public _FinalStage addAddOns(CompanyPlanWithBillingSubView var1);

        public _FinalStage addAllAddOns(List<CompanyPlanWithBillingSubView> var1);

        public _FinalStage billingSubscription(Optional<BillingSubscriptionView> var1);

        public _FinalStage billingSubscription(BillingSubscriptionView var1);

        public _FinalStage billingSubscriptions(List<BillingSubscriptionView> var1);

        public _FinalStage addBillingSubscriptions(BillingSubscriptionView var1);

        public _FinalStage addAllBillingSubscriptions(List<BillingSubscriptionView> var1);

        public _FinalStage entityTraits(List<EntityTraitDetailResponseData> var1);

        public _FinalStage addEntityTraits(EntityTraitDetailResponseData var1);

        public _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> var1);

        public _FinalStage keys(List<EntityKeyDetailResponseData> var1);

        public _FinalStage addKeys(EntityKeyDetailResponseData var1);

        public _FinalStage addAllKeys(List<EntityKeyDetailResponseData> var1);

        public _FinalStage lastSeenAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastSeenAt(OffsetDateTime var1);

        public _FinalStage logoUrl(Optional<String> var1);

        public _FinalStage logoUrl(String var1);

        public _FinalStage metrics(List<CompanyEventPeriodMetricsResponseData> var1);

        public _FinalStage addMetrics(CompanyEventPeriodMetricsResponseData var1);

        public _FinalStage addAllMetrics(List<CompanyEventPeriodMetricsResponseData> var1);

        public _FinalStage plan(Optional<CompanyPlanWithBillingSubView> var1);

        public _FinalStage plan(CompanyPlanWithBillingSubView var1);

        public _FinalStage plans(List<GenericPreviewObject> var1);

        public _FinalStage addPlans(GenericPreviewObject var1);

        public _FinalStage addAllPlans(List<GenericPreviewObject> var1);

        public _FinalStage traits(Optional<Map<String, JsonNode>> var1);

        public _FinalStage traits(Map<String, JsonNode> var1);
    }

    public static interface UserCountStage {
        public _FinalStage userCount(int var1);
    }

    public static interface UpdatedAtStage {
        public UserCountStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(CompanyDetailResponseData var1);
    }
}

