/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyEventPeriodMetricsResponseData {
    private final String accountId;
    private final OffsetDateTime capturedAtMax;
    private final OffsetDateTime capturedAtMin;
    private final String companyId;
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final String eventSubtype;
    private final String monthReset;
    private final String period;
    private final Optional<OffsetDateTime> validUntil;
    private final int value;
    private final Map<String, Object> additionalProperties;

    private CompanyEventPeriodMetricsResponseData(String accountId, OffsetDateTime capturedAtMax, OffsetDateTime capturedAtMin, String companyId, OffsetDateTime createdAt, String environmentId, String eventSubtype, String monthReset, String period, Optional<OffsetDateTime> validUntil, int value, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.capturedAtMax = capturedAtMax;
        this.capturedAtMin = capturedAtMin;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.eventSubtype = eventSubtype;
        this.monthReset = monthReset;
        this.period = period;
        this.validUntil = validUntil;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="captured_at_max")
    public OffsetDateTime getCapturedAtMax() {
        return this.capturedAtMax;
    }

    @JsonProperty(value="captured_at_min")
    public OffsetDateTime getCapturedAtMin() {
        return this.capturedAtMin;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="event_subtype")
    public String getEventSubtype() {
        return this.eventSubtype;
    }

    @JsonProperty(value="month_reset")
    public String getMonthReset() {
        return this.monthReset;
    }

    @JsonProperty(value="period")
    public String getPeriod() {
        return this.period;
    }

    @JsonProperty(value="valid_until")
    public Optional<OffsetDateTime> getValidUntil() {
        return this.validUntil;
    }

    @JsonProperty(value="value")
    public int getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyEventPeriodMetricsResponseData && this.equalTo((CompanyEventPeriodMetricsResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyEventPeriodMetricsResponseData other) {
        return this.accountId.equals(other.accountId) && this.capturedAtMax.equals(other.capturedAtMax) && this.capturedAtMin.equals(other.capturedAtMin) && this.companyId.equals(other.companyId) && this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.eventSubtype.equals(other.eventSubtype) && this.monthReset.equals(other.monthReset) && this.period.equals(other.period) && this.validUntil.equals(other.validUntil) && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.capturedAtMax, this.capturedAtMin, this.companyId, this.createdAt, this.environmentId, this.eventSubtype, this.monthReset, this.period, this.validUntil, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    CapturedAtMaxStage,
    CapturedAtMinStage,
    CompanyIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    EventSubtypeStage,
    MonthResetStage,
    PeriodStage,
    ValueStage,
    _FinalStage {
        private String accountId;
        private OffsetDateTime capturedAtMax;
        private OffsetDateTime capturedAtMin;
        private String companyId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private String eventSubtype;
        private String monthReset;
        private String period;
        private int value;
        private Optional<OffsetDateTime> validUntil = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyEventPeriodMetricsResponseData other) {
            this.accountId(other.getAccountId());
            this.capturedAtMax(other.getCapturedAtMax());
            this.capturedAtMin(other.getCapturedAtMin());
            this.companyId(other.getCompanyId());
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.eventSubtype(other.getEventSubtype());
            this.monthReset(other.getMonthReset());
            this.period(other.getPeriod());
            this.validUntil(other.getValidUntil());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public CapturedAtMaxStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="captured_at_max")
        public CapturedAtMinStage capturedAtMax(@NotNull OffsetDateTime capturedAtMax) {
            this.capturedAtMax = Objects.requireNonNull(capturedAtMax, "capturedAtMax must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="captured_at_min")
        public CompanyIdStage capturedAtMin(@NotNull OffsetDateTime capturedAtMin) {
            this.capturedAtMin = Objects.requireNonNull(capturedAtMin, "capturedAtMin must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CreatedAtStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public EventSubtypeStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_subtype")
        public MonthResetStage eventSubtype(@NotNull String eventSubtype) {
            this.eventSubtype = Objects.requireNonNull(eventSubtype, "eventSubtype must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="month_reset")
        public PeriodStage monthReset(@NotNull String monthReset) {
            this.monthReset = Objects.requireNonNull(monthReset, "monthReset must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="period")
        public ValueStage period(@NotNull String period) {
            this.period = Objects.requireNonNull(period, "period must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(int value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage validUntil(OffsetDateTime validUntil) {
            this.validUntil = Optional.ofNullable(validUntil);
            return this;
        }

        @Override
        @JsonSetter(value="valid_until", nulls=Nulls.SKIP)
        public _FinalStage validUntil(Optional<OffsetDateTime> validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        @Override
        public CompanyEventPeriodMetricsResponseData build() {
            return new CompanyEventPeriodMetricsResponseData(this.accountId, this.capturedAtMax, this.capturedAtMin, this.companyId, this.createdAt, this.environmentId, this.eventSubtype, this.monthReset, this.period, this.validUntil, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyEventPeriodMetricsResponseData build();

        public _FinalStage validUntil(Optional<OffsetDateTime> var1);

        public _FinalStage validUntil(OffsetDateTime var1);
    }

    public static interface ValueStage {
        public _FinalStage value(int var1);
    }

    public static interface PeriodStage {
        public ValueStage period(@NotNull String var1);
    }

    public static interface MonthResetStage {
        public PeriodStage monthReset(@NotNull String var1);
    }

    public static interface EventSubtypeStage {
        public MonthResetStage eventSubtype(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public EventSubtypeStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CompanyIdStage {
        public CreatedAtStage companyId(@NotNull String var1);
    }

    public static interface CapturedAtMinStage {
        public CompanyIdStage capturedAtMin(@NotNull OffsetDateTime var1);
    }

    public static interface CapturedAtMaxStage {
        public CapturedAtMinStage capturedAtMax(@NotNull OffsetDateTime var1);
    }

    public static interface AccountIdStage {
        public CapturedAtMaxStage accountId(@NotNull String var1);

        public Builder from(CompanyEventPeriodMetricsResponseData var1);
    }
}

