/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CompanyResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyMembershipDetailResponseData {
    private final Optional<CompanyResponseData> company;
    private final String companyId;
    private final OffsetDateTime createdAt;
    private final String id;
    private final OffsetDateTime updatedAt;
    private final String userId;
    private final Map<String, Object> additionalProperties;

    private CompanyMembershipDetailResponseData(Optional<CompanyResponseData> company, String companyId, OffsetDateTime createdAt, String id, OffsetDateTime updatedAt, String userId, Map<String, Object> additionalProperties) {
        this.company = company;
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.id = id;
        this.updatedAt = updatedAt;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company")
    public Optional<CompanyResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="company_id")
    public String getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="user_id")
    public String getUserId() {
        return this.userId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyMembershipDetailResponseData && this.equalTo((CompanyMembershipDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyMembershipDetailResponseData other) {
        return this.company.equals(other.company) && this.companyId.equals(other.companyId) && this.createdAt.equals(other.createdAt) && this.id.equals(other.id) && this.updatedAt.equals(other.updatedAt) && this.userId.equals(other.userId);
    }

    public int hashCode() {
        return Objects.hash(this.company, this.companyId, this.createdAt, this.id, this.updatedAt, this.userId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyIdStage,
    CreatedAtStage,
    IdStage,
    UpdatedAtStage,
    UserIdStage,
    _FinalStage {
        private String companyId;
        private OffsetDateTime createdAt;
        private String id;
        private OffsetDateTime updatedAt;
        private String userId;
        private Optional<CompanyResponseData> company = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyMembershipDetailResponseData other) {
            this.company(other.getCompany());
            this.companyId(other.getCompanyId());
            this.createdAt(other.getCreatedAt());
            this.id(other.getId());
            this.updatedAt(other.getUpdatedAt());
            this.userId(other.getUserId());
            return this;
        }

        @Override
        @JsonSetter(value="company_id")
        public CreatedAtStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public UpdatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public UserIdStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @Override
        public _FinalStage company(CompanyResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<CompanyResponseData> company) {
            this.company = company;
            return this;
        }

        @Override
        public CompanyMembershipDetailResponseData build() {
            return new CompanyMembershipDetailResponseData(this.company, this.companyId, this.createdAt, this.id, this.updatedAt, this.userId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyMembershipDetailResponseData build();

        public _FinalStage company(Optional<CompanyResponseData> var1);

        public _FinalStage company(CompanyResponseData var1);
    }

    public static interface UserIdStage {
        public _FinalStage userId(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public UserIdStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface IdStage {
        public UpdatedAtStage id(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public IdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CompanyIdStage {
        public CreatedAtStage companyId(@NotNull String var1);

        public Builder from(CompanyMembershipDetailResponseData var1);
    }
}

