/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.BillingPriceResponseData;
import com.schematic.api.types.BillingProductDetailResponseData;
import com.schematic.api.types.FeatureDetailResponseData;
import com.schematic.api.types.PlanEntitlementResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyPlanDetailResponseData {
    private final Optional<String> audienceType;
    private final Optional<BillingProductDetailResponseData> billingProduct;
    private final boolean companyCanTrial;
    private final int companyCount;
    private final OffsetDateTime createdAt;
    private final boolean current;
    private final String description;
    private final List<PlanEntitlementResponseData> entitlements;
    private final List<FeatureDetailResponseData> features;
    private final String icon;
    private final String id;
    private final boolean isDefault;
    private final boolean isFree;
    private final boolean isTrialable;
    private final Optional<BillingPriceResponseData> monthlyPrice;
    private final String name;
    private final String planType;
    private final Optional<Integer> trialDays;
    private final OffsetDateTime updatedAt;
    private final boolean valid;
    private final Optional<BillingPriceResponseData> yearlyPrice;
    private final Map<String, Object> additionalProperties;

    private CompanyPlanDetailResponseData(Optional<String> audienceType, Optional<BillingProductDetailResponseData> billingProduct, boolean companyCanTrial, int companyCount, OffsetDateTime createdAt, boolean current, String description, List<PlanEntitlementResponseData> entitlements, List<FeatureDetailResponseData> features, String icon, String id, boolean isDefault, boolean isFree, boolean isTrialable, Optional<BillingPriceResponseData> monthlyPrice, String name, String planType, Optional<Integer> trialDays, OffsetDateTime updatedAt, boolean valid, Optional<BillingPriceResponseData> yearlyPrice, Map<String, Object> additionalProperties) {
        this.audienceType = audienceType;
        this.billingProduct = billingProduct;
        this.companyCanTrial = companyCanTrial;
        this.companyCount = companyCount;
        this.createdAt = createdAt;
        this.current = current;
        this.description = description;
        this.entitlements = entitlements;
        this.features = features;
        this.icon = icon;
        this.id = id;
        this.isDefault = isDefault;
        this.isFree = isFree;
        this.isTrialable = isTrialable;
        this.monthlyPrice = monthlyPrice;
        this.name = name;
        this.planType = planType;
        this.trialDays = trialDays;
        this.updatedAt = updatedAt;
        this.valid = valid;
        this.yearlyPrice = yearlyPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="audience_type")
    public Optional<String> getAudienceType() {
        return this.audienceType;
    }

    @JsonProperty(value="billing_product")
    public Optional<BillingProductDetailResponseData> getBillingProduct() {
        return this.billingProduct;
    }

    @JsonProperty(value="company_can_trial")
    public boolean getCompanyCanTrial() {
        return this.companyCanTrial;
    }

    @JsonProperty(value="company_count")
    public int getCompanyCount() {
        return this.companyCount;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="current")
    public boolean getCurrent() {
        return this.current;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="entitlements")
    public List<PlanEntitlementResponseData> getEntitlements() {
        return this.entitlements;
    }

    @JsonProperty(value="features")
    public List<FeatureDetailResponseData> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="is_default")
    public boolean getIsDefault() {
        return this.isDefault;
    }

    @JsonProperty(value="is_free")
    public boolean getIsFree() {
        return this.isFree;
    }

    @JsonProperty(value="is_trialable")
    public boolean getIsTrialable() {
        return this.isTrialable;
    }

    @JsonProperty(value="monthly_price")
    public Optional<BillingPriceResponseData> getMonthlyPrice() {
        return this.monthlyPrice;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plan_type")
    public String getPlanType() {
        return this.planType;
    }

    @JsonProperty(value="trial_days")
    public Optional<Integer> getTrialDays() {
        return this.trialDays;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="valid")
    public boolean getValid() {
        return this.valid;
    }

    @JsonProperty(value="yearly_price")
    public Optional<BillingPriceResponseData> getYearlyPrice() {
        return this.yearlyPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyPlanDetailResponseData && this.equalTo((CompanyPlanDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyPlanDetailResponseData other) {
        return this.audienceType.equals(other.audienceType) && this.billingProduct.equals(other.billingProduct) && this.companyCanTrial == other.companyCanTrial && this.companyCount == other.companyCount && this.createdAt.equals(other.createdAt) && this.current == other.current && this.description.equals(other.description) && this.entitlements.equals(other.entitlements) && this.features.equals(other.features) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.isDefault == other.isDefault && this.isFree == other.isFree && this.isTrialable == other.isTrialable && this.monthlyPrice.equals(other.monthlyPrice) && this.name.equals(other.name) && this.planType.equals(other.planType) && this.trialDays.equals(other.trialDays) && this.updatedAt.equals(other.updatedAt) && this.valid == other.valid && this.yearlyPrice.equals(other.yearlyPrice);
    }

    public int hashCode() {
        return Objects.hash(this.audienceType, this.billingProduct, this.companyCanTrial, this.companyCount, this.createdAt, this.current, this.description, this.entitlements, this.features, this.icon, this.id, this.isDefault, this.isFree, this.isTrialable, this.monthlyPrice, this.name, this.planType, this.trialDays, this.updatedAt, this.valid, this.yearlyPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyCanTrialStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyCanTrialStage,
    CompanyCountStage,
    CreatedAtStage,
    CurrentStage,
    DescriptionStage,
    IconStage,
    IdStage,
    IsDefaultStage,
    IsFreeStage,
    IsTrialableStage,
    NameStage,
    PlanTypeStage,
    UpdatedAtStage,
    ValidStage,
    _FinalStage {
        private boolean companyCanTrial;
        private int companyCount;
        private OffsetDateTime createdAt;
        private boolean current;
        private String description;
        private String icon;
        private String id;
        private boolean isDefault;
        private boolean isFree;
        private boolean isTrialable;
        private String name;
        private String planType;
        private OffsetDateTime updatedAt;
        private boolean valid;
        private Optional<BillingPriceResponseData> yearlyPrice = Optional.empty();
        private Optional<Integer> trialDays = Optional.empty();
        private Optional<BillingPriceResponseData> monthlyPrice = Optional.empty();
        private List<FeatureDetailResponseData> features = new ArrayList<FeatureDetailResponseData>();
        private List<PlanEntitlementResponseData> entitlements = new ArrayList<PlanEntitlementResponseData>();
        private Optional<BillingProductDetailResponseData> billingProduct = Optional.empty();
        private Optional<String> audienceType = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyPlanDetailResponseData other) {
            this.audienceType(other.getAudienceType());
            this.billingProduct(other.getBillingProduct());
            this.companyCanTrial(other.getCompanyCanTrial());
            this.companyCount(other.getCompanyCount());
            this.createdAt(other.getCreatedAt());
            this.current(other.getCurrent());
            this.description(other.getDescription());
            this.entitlements(other.getEntitlements());
            this.features(other.getFeatures());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.isDefault(other.getIsDefault());
            this.isFree(other.getIsFree());
            this.isTrialable(other.getIsTrialable());
            this.monthlyPrice(other.getMonthlyPrice());
            this.name(other.getName());
            this.planType(other.getPlanType());
            this.trialDays(other.getTrialDays());
            this.updatedAt(other.getUpdatedAt());
            this.valid(other.getValid());
            this.yearlyPrice(other.getYearlyPrice());
            return this;
        }

        @Override
        @JsonSetter(value="company_can_trial")
        public CompanyCountStage companyCanTrial(boolean companyCanTrial) {
            this.companyCanTrial = companyCanTrial;
            return this;
        }

        @Override
        @JsonSetter(value="company_count")
        public CreatedAtStage companyCount(int companyCount) {
            this.companyCount = companyCount;
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public CurrentStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="current")
        public DescriptionStage current(boolean current) {
            this.current = current;
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public IsDefaultStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="is_default")
        public IsFreeStage isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @Override
        @JsonSetter(value="is_free")
        public IsTrialableStage isFree(boolean isFree) {
            this.isFree = isFree;
            return this;
        }

        @Override
        @JsonSetter(value="is_trialable")
        public NameStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="plan_type")
        public UpdatedAtStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public ValidStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="valid")
        public _FinalStage valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        @Override
        public _FinalStage yearlyPrice(BillingPriceResponseData yearlyPrice) {
            this.yearlyPrice = Optional.ofNullable(yearlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="yearly_price", nulls=Nulls.SKIP)
        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> yearlyPrice) {
            this.yearlyPrice = yearlyPrice;
            return this;
        }

        @Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @Override
        @JsonSetter(value="trial_days", nulls=Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @Override
        public _FinalStage monthlyPrice(BillingPriceResponseData monthlyPrice) {
            this.monthlyPrice = Optional.ofNullable(monthlyPrice);
            return this;
        }

        @Override
        @JsonSetter(value="monthly_price", nulls=Nulls.SKIP)
        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> monthlyPrice) {
            this.monthlyPrice = monthlyPrice;
            return this;
        }

        @Override
        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> features) {
            this.features.addAll(features);
            return this;
        }

        @Override
        public _FinalStage addFeatures(FeatureDetailResponseData features) {
            this.features.add(features);
            return this;
        }

        @Override
        @JsonSetter(value="features", nulls=Nulls.SKIP)
        public _FinalStage features(List<FeatureDetailResponseData> features) {
            this.features.clear();
            this.features.addAll(features);
            return this;
        }

        @Override
        public _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> entitlements) {
            this.entitlements.addAll(entitlements);
            return this;
        }

        @Override
        public _FinalStage addEntitlements(PlanEntitlementResponseData entitlements) {
            this.entitlements.add(entitlements);
            return this;
        }

        @Override
        @JsonSetter(value="entitlements", nulls=Nulls.SKIP)
        public _FinalStage entitlements(List<PlanEntitlementResponseData> entitlements) {
            this.entitlements.clear();
            this.entitlements.addAll(entitlements);
            return this;
        }

        @Override
        public _FinalStage billingProduct(BillingProductDetailResponseData billingProduct) {
            this.billingProduct = Optional.ofNullable(billingProduct);
            return this;
        }

        @Override
        @JsonSetter(value="billing_product", nulls=Nulls.SKIP)
        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> billingProduct) {
            this.billingProduct = billingProduct;
            return this;
        }

        @Override
        public _FinalStage audienceType(String audienceType) {
            this.audienceType = Optional.ofNullable(audienceType);
            return this;
        }

        @Override
        @JsonSetter(value="audience_type", nulls=Nulls.SKIP)
        public _FinalStage audienceType(Optional<String> audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        @Override
        public CompanyPlanDetailResponseData build() {
            return new CompanyPlanDetailResponseData(this.audienceType, this.billingProduct, this.companyCanTrial, this.companyCount, this.createdAt, this.current, this.description, this.entitlements, this.features, this.icon, this.id, this.isDefault, this.isFree, this.isTrialable, this.monthlyPrice, this.name, this.planType, this.trialDays, this.updatedAt, this.valid, this.yearlyPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyPlanDetailResponseData build();

        public _FinalStage audienceType(Optional<String> var1);

        public _FinalStage audienceType(String var1);

        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> var1);

        public _FinalStage billingProduct(BillingProductDetailResponseData var1);

        public _FinalStage entitlements(List<PlanEntitlementResponseData> var1);

        public _FinalStage addEntitlements(PlanEntitlementResponseData var1);

        public _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> var1);

        public _FinalStage features(List<FeatureDetailResponseData> var1);

        public _FinalStage addFeatures(FeatureDetailResponseData var1);

        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> var1);

        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage monthlyPrice(BillingPriceResponseData var1);

        public _FinalStage trialDays(Optional<Integer> var1);

        public _FinalStage trialDays(Integer var1);

        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> var1);

        public _FinalStage yearlyPrice(BillingPriceResponseData var1);
    }

    public static interface ValidStage {
        public _FinalStage valid(boolean var1);
    }

    public static interface UpdatedAtStage {
        public ValidStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface PlanTypeStage {
        public UpdatedAtStage planType(@NotNull String var1);
    }

    public static interface NameStage {
        public PlanTypeStage name(@NotNull String var1);
    }

    public static interface IsTrialableStage {
        public NameStage isTrialable(boolean var1);
    }

    public static interface IsFreeStage {
        public IsTrialableStage isFree(boolean var1);
    }

    public static interface IsDefaultStage {
        public IsFreeStage isDefault(boolean var1);
    }

    public static interface IdStage {
        public IsDefaultStage id(@NotNull String var1);
    }

    public static interface IconStage {
        public IdStage icon(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public IconStage description(@NotNull String var1);
    }

    public static interface CurrentStage {
        public DescriptionStage current(boolean var1);
    }

    public static interface CreatedAtStage {
        public CurrentStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface CompanyCountStage {
        public CreatedAtStage companyCount(int var1);
    }

    public static interface CompanyCanTrialStage {
        public CompanyCountStage companyCanTrial(boolean var1);

        public Builder from(CompanyPlanDetailResponseData var1);
    }
}

