/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CompanyPlanWithBillingSubView {
    private final Optional<String> billingProductId;
    private final Optional<String> description;
    private final String id;
    private final Optional<String> imageUrl;
    private final String name;
    private final Optional<String> planPeriod;
    private final Optional<Integer> planPrice;
    private final Map<String, Object> additionalProperties;

    private CompanyPlanWithBillingSubView(Optional<String> billingProductId, Optional<String> description, String id, Optional<String> imageUrl, String name, Optional<String> planPeriod, Optional<Integer> planPrice, Map<String, Object> additionalProperties) {
        this.billingProductId = billingProductId;
        this.description = description;
        this.id = id;
        this.imageUrl = imageUrl;
        this.name = name;
        this.planPeriod = planPeriod;
        this.planPrice = planPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billing_product_id")
    public Optional<String> getBillingProductId() {
        return this.billingProductId;
    }

    @JsonProperty(value="description")
    public Optional<String> getDescription() {
        return this.description;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="image_url")
    public Optional<String> getImageUrl() {
        return this.imageUrl;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="plan_period")
    public Optional<String> getPlanPeriod() {
        return this.planPeriod;
    }

    @JsonProperty(value="plan_price")
    public Optional<Integer> getPlanPrice() {
        return this.planPrice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CompanyPlanWithBillingSubView && this.equalTo((CompanyPlanWithBillingSubView)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyPlanWithBillingSubView other) {
        return this.billingProductId.equals(other.billingProductId) && this.description.equals(other.description) && this.id.equals(other.id) && this.imageUrl.equals(other.imageUrl) && this.name.equals(other.name) && this.planPeriod.equals(other.planPeriod) && this.planPrice.equals(other.planPrice);
    }

    public int hashCode() {
        return Objects.hash(this.billingProductId, this.description, this.id, this.imageUrl, this.name, this.planPeriod, this.planPrice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    NameStage,
    _FinalStage {
        private String id;
        private String name;
        private Optional<Integer> planPrice = Optional.empty();
        private Optional<String> planPeriod = Optional.empty();
        private Optional<String> imageUrl = Optional.empty();
        private Optional<String> description = Optional.empty();
        private Optional<String> billingProductId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CompanyPlanWithBillingSubView other) {
            this.billingProductId(other.getBillingProductId());
            this.description(other.getDescription());
            this.id(other.getId());
            this.imageUrl(other.getImageUrl());
            this.name(other.getName());
            this.planPeriod(other.getPlanPeriod());
            this.planPrice(other.getPlanPrice());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        public _FinalStage planPrice(Integer planPrice) {
            this.planPrice = Optional.ofNullable(planPrice);
            return this;
        }

        @Override
        @JsonSetter(value="plan_price", nulls=Nulls.SKIP)
        public _FinalStage planPrice(Optional<Integer> planPrice) {
            this.planPrice = planPrice;
            return this;
        }

        @Override
        public _FinalStage planPeriod(String planPeriod) {
            this.planPeriod = Optional.ofNullable(planPeriod);
            return this;
        }

        @Override
        @JsonSetter(value="plan_period", nulls=Nulls.SKIP)
        public _FinalStage planPeriod(Optional<String> planPeriod) {
            this.planPeriod = planPeriod;
            return this;
        }

        @Override
        public _FinalStage imageUrl(String imageUrl) {
            this.imageUrl = Optional.ofNullable(imageUrl);
            return this;
        }

        @Override
        @JsonSetter(value="image_url", nulls=Nulls.SKIP)
        public _FinalStage imageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        @Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @Override
        @JsonSetter(value="description", nulls=Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @Override
        public _FinalStage billingProductId(String billingProductId) {
            this.billingProductId = Optional.ofNullable(billingProductId);
            return this;
        }

        @Override
        @JsonSetter(value="billing_product_id", nulls=Nulls.SKIP)
        public _FinalStage billingProductId(Optional<String> billingProductId) {
            this.billingProductId = billingProductId;
            return this;
        }

        @Override
        public CompanyPlanWithBillingSubView build() {
            return new CompanyPlanWithBillingSubView(this.billingProductId, this.description, this.id, this.imageUrl, this.name, this.planPeriod, this.planPrice, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CompanyPlanWithBillingSubView build();

        public _FinalStage billingProductId(Optional<String> var1);

        public _FinalStage billingProductId(String var1);

        public _FinalStage description(Optional<String> var1);

        public _FinalStage description(String var1);

        public _FinalStage imageUrl(Optional<String> var1);

        public _FinalStage imageUrl(String var1);

        public _FinalStage planPeriod(Optional<String> var1);

        public _FinalStage planPeriod(String var1);

        public _FinalStage planPrice(Optional<Integer> var1);

        public _FinalStage planPrice(Integer var1);
    }

    public static interface NameStage {
        public _FinalStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);

        public Builder from(CompanyPlanWithBillingSubView var1);
    }
}

