/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CompanyDetailResponseData;
import com.schematic.api.types.CompanyPlanDetailResponseData;
import com.schematic.api.types.CompanySubscriptionResponseData;
import com.schematic.api.types.ComponentCapabilities;
import com.schematic.api.types.ComponentResponseData;
import com.schematic.api.types.FeatureUsageDetailResponseData;
import com.schematic.api.types.InvoiceResponseData;
import com.schematic.api.types.PlanDetailResponseData;
import com.schematic.api.types.StripeEmbedInfo;
import com.schematic.api.types.UsageBasedEntitlementResponseData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ComponentPreviewResponseData {
    private final List<CompanyPlanDetailResponseData> activeAddOns;
    private final List<CompanyPlanDetailResponseData> activePlans;
    private final List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements;
    private final Optional<ComponentCapabilities> capabilities;
    private final Optional<CompanyDetailResponseData> company;
    private final Optional<ComponentResponseData> component;
    private final Optional<PlanDetailResponseData> defaultPlan;
    private final Optional<FeatureUsageDetailResponseData> featureUsage;
    private final List<InvoiceResponseData> invoices;
    private final Optional<StripeEmbedInfo> stripeEmbed;
    private final Optional<CompanySubscriptionResponseData> subscription;
    private final Optional<Boolean> trialPaymentMethodRequired;
    private final Optional<InvoiceResponseData> upcomingInvoice;
    private final Map<String, Object> additionalProperties;

    private ComponentPreviewResponseData(List<CompanyPlanDetailResponseData> activeAddOns, List<CompanyPlanDetailResponseData> activePlans, List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements, Optional<ComponentCapabilities> capabilities, Optional<CompanyDetailResponseData> company, Optional<ComponentResponseData> component, Optional<PlanDetailResponseData> defaultPlan, Optional<FeatureUsageDetailResponseData> featureUsage, List<InvoiceResponseData> invoices, Optional<StripeEmbedInfo> stripeEmbed, Optional<CompanySubscriptionResponseData> subscription, Optional<Boolean> trialPaymentMethodRequired, Optional<InvoiceResponseData> upcomingInvoice, Map<String, Object> additionalProperties) {
        this.activeAddOns = activeAddOns;
        this.activePlans = activePlans;
        this.activeUsageBasedEntitlements = activeUsageBasedEntitlements;
        this.capabilities = capabilities;
        this.company = company;
        this.component = component;
        this.defaultPlan = defaultPlan;
        this.featureUsage = featureUsage;
        this.invoices = invoices;
        this.stripeEmbed = stripeEmbed;
        this.subscription = subscription;
        this.trialPaymentMethodRequired = trialPaymentMethodRequired;
        this.upcomingInvoice = upcomingInvoice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="active_add_ons")
    public List<CompanyPlanDetailResponseData> getActiveAddOns() {
        return this.activeAddOns;
    }

    @JsonProperty(value="active_plans")
    public List<CompanyPlanDetailResponseData> getActivePlans() {
        return this.activePlans;
    }

    @JsonProperty(value="active_usage_based_entitlements")
    public List<UsageBasedEntitlementResponseData> getActiveUsageBasedEntitlements() {
        return this.activeUsageBasedEntitlements;
    }

    @JsonProperty(value="capabilities")
    public Optional<ComponentCapabilities> getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="component")
    public Optional<ComponentResponseData> getComponent() {
        return this.component;
    }

    @JsonProperty(value="default_plan")
    public Optional<PlanDetailResponseData> getDefaultPlan() {
        return this.defaultPlan;
    }

    @JsonProperty(value="feature_usage")
    public Optional<FeatureUsageDetailResponseData> getFeatureUsage() {
        return this.featureUsage;
    }

    @JsonProperty(value="invoices")
    public List<InvoiceResponseData> getInvoices() {
        return this.invoices;
    }

    @JsonProperty(value="stripe_embed")
    public Optional<StripeEmbedInfo> getStripeEmbed() {
        return this.stripeEmbed;
    }

    @JsonProperty(value="subscription")
    public Optional<CompanySubscriptionResponseData> getSubscription() {
        return this.subscription;
    }

    @JsonProperty(value="trial_payment_method_required")
    public Optional<Boolean> getTrialPaymentMethodRequired() {
        return this.trialPaymentMethodRequired;
    }

    @JsonProperty(value="upcoming_invoice")
    public Optional<InvoiceResponseData> getUpcomingInvoice() {
        return this.upcomingInvoice;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ComponentPreviewResponseData && this.equalTo((ComponentPreviewResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ComponentPreviewResponseData other) {
        return this.activeAddOns.equals(other.activeAddOns) && this.activePlans.equals(other.activePlans) && this.activeUsageBasedEntitlements.equals(other.activeUsageBasedEntitlements) && this.capabilities.equals(other.capabilities) && this.company.equals(other.company) && this.component.equals(other.component) && this.defaultPlan.equals(other.defaultPlan) && this.featureUsage.equals(other.featureUsage) && this.invoices.equals(other.invoices) && this.stripeEmbed.equals(other.stripeEmbed) && this.subscription.equals(other.subscription) && this.trialPaymentMethodRequired.equals(other.trialPaymentMethodRequired) && this.upcomingInvoice.equals(other.upcomingInvoice);
    }

    public int hashCode() {
        return Objects.hash(this.activeAddOns, this.activePlans, this.activeUsageBasedEntitlements, this.capabilities, this.company, this.component, this.defaultPlan, this.featureUsage, this.invoices, this.stripeEmbed, this.subscription, this.trialPaymentMethodRequired, this.upcomingInvoice);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private List<CompanyPlanDetailResponseData> activeAddOns = new ArrayList<CompanyPlanDetailResponseData>();
        private List<CompanyPlanDetailResponseData> activePlans = new ArrayList<CompanyPlanDetailResponseData>();
        private List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements = new ArrayList<UsageBasedEntitlementResponseData>();
        private Optional<ComponentCapabilities> capabilities = Optional.empty();
        private Optional<CompanyDetailResponseData> company = Optional.empty();
        private Optional<ComponentResponseData> component = Optional.empty();
        private Optional<PlanDetailResponseData> defaultPlan = Optional.empty();
        private Optional<FeatureUsageDetailResponseData> featureUsage = Optional.empty();
        private List<InvoiceResponseData> invoices = new ArrayList<InvoiceResponseData>();
        private Optional<StripeEmbedInfo> stripeEmbed = Optional.empty();
        private Optional<CompanySubscriptionResponseData> subscription = Optional.empty();
        private Optional<Boolean> trialPaymentMethodRequired = Optional.empty();
        private Optional<InvoiceResponseData> upcomingInvoice = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(ComponentPreviewResponseData other) {
            this.activeAddOns(other.getActiveAddOns());
            this.activePlans(other.getActivePlans());
            this.activeUsageBasedEntitlements(other.getActiveUsageBasedEntitlements());
            this.capabilities(other.getCapabilities());
            this.company(other.getCompany());
            this.component(other.getComponent());
            this.defaultPlan(other.getDefaultPlan());
            this.featureUsage(other.getFeatureUsage());
            this.invoices(other.getInvoices());
            this.stripeEmbed(other.getStripeEmbed());
            this.subscription(other.getSubscription());
            this.trialPaymentMethodRequired(other.getTrialPaymentMethodRequired());
            this.upcomingInvoice(other.getUpcomingInvoice());
            return this;
        }

        @JsonSetter(value="active_add_ons", nulls=Nulls.SKIP)
        public Builder activeAddOns(List<CompanyPlanDetailResponseData> activeAddOns) {
            this.activeAddOns.clear();
            this.activeAddOns.addAll(activeAddOns);
            return this;
        }

        public Builder addActiveAddOns(CompanyPlanDetailResponseData activeAddOns) {
            this.activeAddOns.add(activeAddOns);
            return this;
        }

        public Builder addAllActiveAddOns(List<CompanyPlanDetailResponseData> activeAddOns) {
            this.activeAddOns.addAll(activeAddOns);
            return this;
        }

        @JsonSetter(value="active_plans", nulls=Nulls.SKIP)
        public Builder activePlans(List<CompanyPlanDetailResponseData> activePlans) {
            this.activePlans.clear();
            this.activePlans.addAll(activePlans);
            return this;
        }

        public Builder addActivePlans(CompanyPlanDetailResponseData activePlans) {
            this.activePlans.add(activePlans);
            return this;
        }

        public Builder addAllActivePlans(List<CompanyPlanDetailResponseData> activePlans) {
            this.activePlans.addAll(activePlans);
            return this;
        }

        @JsonSetter(value="active_usage_based_entitlements", nulls=Nulls.SKIP)
        public Builder activeUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.clear();
            this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            return this;
        }

        public Builder addActiveUsageBasedEntitlements(UsageBasedEntitlementResponseData activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.add(activeUsageBasedEntitlements);
            return this;
        }

        public Builder addAllActiveUsageBasedEntitlements(List<UsageBasedEntitlementResponseData> activeUsageBasedEntitlements) {
            this.activeUsageBasedEntitlements.addAll(activeUsageBasedEntitlements);
            return this;
        }

        @JsonSetter(value="capabilities", nulls=Nulls.SKIP)
        public Builder capabilities(Optional<ComponentCapabilities> capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public Builder capabilities(ComponentCapabilities capabilities) {
            this.capabilities = Optional.ofNullable(capabilities);
            return this;
        }

        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public Builder company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        public Builder company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @JsonSetter(value="component", nulls=Nulls.SKIP)
        public Builder component(Optional<ComponentResponseData> component) {
            this.component = component;
            return this;
        }

        public Builder component(ComponentResponseData component) {
            this.component = Optional.ofNullable(component);
            return this;
        }

        @JsonSetter(value="default_plan", nulls=Nulls.SKIP)
        public Builder defaultPlan(Optional<PlanDetailResponseData> defaultPlan) {
            this.defaultPlan = defaultPlan;
            return this;
        }

        public Builder defaultPlan(PlanDetailResponseData defaultPlan) {
            this.defaultPlan = Optional.ofNullable(defaultPlan);
            return this;
        }

        @JsonSetter(value="feature_usage", nulls=Nulls.SKIP)
        public Builder featureUsage(Optional<FeatureUsageDetailResponseData> featureUsage) {
            this.featureUsage = featureUsage;
            return this;
        }

        public Builder featureUsage(FeatureUsageDetailResponseData featureUsage) {
            this.featureUsage = Optional.ofNullable(featureUsage);
            return this;
        }

        @JsonSetter(value="invoices", nulls=Nulls.SKIP)
        public Builder invoices(List<InvoiceResponseData> invoices) {
            this.invoices.clear();
            this.invoices.addAll(invoices);
            return this;
        }

        public Builder addInvoices(InvoiceResponseData invoices) {
            this.invoices.add(invoices);
            return this;
        }

        public Builder addAllInvoices(List<InvoiceResponseData> invoices) {
            this.invoices.addAll(invoices);
            return this;
        }

        @JsonSetter(value="stripe_embed", nulls=Nulls.SKIP)
        public Builder stripeEmbed(Optional<StripeEmbedInfo> stripeEmbed) {
            this.stripeEmbed = stripeEmbed;
            return this;
        }

        public Builder stripeEmbed(StripeEmbedInfo stripeEmbed) {
            this.stripeEmbed = Optional.ofNullable(stripeEmbed);
            return this;
        }

        @JsonSetter(value="subscription", nulls=Nulls.SKIP)
        public Builder subscription(Optional<CompanySubscriptionResponseData> subscription) {
            this.subscription = subscription;
            return this;
        }

        public Builder subscription(CompanySubscriptionResponseData subscription) {
            this.subscription = Optional.ofNullable(subscription);
            return this;
        }

        @JsonSetter(value="trial_payment_method_required", nulls=Nulls.SKIP)
        public Builder trialPaymentMethodRequired(Optional<Boolean> trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = trialPaymentMethodRequired;
            return this;
        }

        public Builder trialPaymentMethodRequired(Boolean trialPaymentMethodRequired) {
            this.trialPaymentMethodRequired = Optional.ofNullable(trialPaymentMethodRequired);
            return this;
        }

        @JsonSetter(value="upcoming_invoice", nulls=Nulls.SKIP)
        public Builder upcomingInvoice(Optional<InvoiceResponseData> upcomingInvoice) {
            this.upcomingInvoice = upcomingInvoice;
            return this;
        }

        public Builder upcomingInvoice(InvoiceResponseData upcomingInvoice) {
            this.upcomingInvoice = Optional.ofNullable(upcomingInvoice);
            return this;
        }

        public ComponentPreviewResponseData build() {
            return new ComponentPreviewResponseData(this.activeAddOns, this.activePlans, this.activeUsageBasedEntitlements, this.capabilities, this.company, this.component, this.defaultPlan, this.featureUsage, this.invoices, this.stripeEmbed, this.subscription, this.trialPaymentMethodRequired, this.upcomingInvoice, this.additionalProperties);
        }
    }
}

