/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ComponentResponseData {
    private final Optional<Map<String, Double>> ast;
    private final OffsetDateTime createdAt;
    private final String id;
    private final String name;
    private final String state;
    private final String type;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private ComponentResponseData(Optional<Map<String, Double>> ast, OffsetDateTime createdAt, String id, String name, String state, String type, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.ast = ast;
        this.createdAt = createdAt;
        this.id = id;
        this.name = name;
        this.state = state;
        this.type = type;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="ast")
    public Optional<Map<String, Double>> getAst() {
        return this.ast;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ComponentResponseData && this.equalTo((ComponentResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ComponentResponseData other) {
        return this.ast.equals(other.ast) && this.createdAt.equals(other.createdAt) && this.id.equals(other.id) && this.name.equals(other.name) && this.state.equals(other.state) && this.type.equals(other.type) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.ast, this.createdAt, this.id, this.name, this.state, this.type, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    IdStage,
    NameStage,
    StateStage,
    TypeStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String id;
        private String name;
        private String state;
        private String type;
        private OffsetDateTime updatedAt;
        private Optional<Map<String, Double>> ast = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ComponentResponseData other) {
            this.ast(other.getAst());
            this.createdAt(other.getCreatedAt());
            this.id(other.getId());
            this.name(other.getName());
            this.state(other.getState());
            this.type(other.getType());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public StateStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="state")
        public TypeStage state(@NotNull String state) {
            this.state = Objects.requireNonNull(state, "state must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public UpdatedAtStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage ast(Map<String, Double> ast) {
            this.ast = Optional.ofNullable(ast);
            return this;
        }

        @Override
        @JsonSetter(value="ast", nulls=Nulls.SKIP)
        public _FinalStage ast(Optional<Map<String, Double>> ast) {
            this.ast = ast;
            return this;
        }

        @Override
        public ComponentResponseData build() {
            return new ComponentResponseData(this.ast, this.createdAt, this.id, this.name, this.state, this.type, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ComponentResponseData build();

        public _FinalStage ast(Optional<Map<String, Double>> var1);

        public _FinalStage ast(Map<String, Double> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface TypeStage {
        public UpdatedAtStage type(@NotNull String var1);
    }

    public static interface StateStage {
        public TypeStage state(@NotNull String var1);
    }

    public static interface NameStage {
        public StateStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public IdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(ComponentResponseData var1);
    }
}

