/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CrmDealResponseData {
    private final String accountId;
    private final String arr;
    private final Optional<String> companyExternalId;
    private final OffsetDateTime createdAt;
    private final String dealExternalId;
    private final String dealId;
    private final String environmentId;
    private final String mrr;
    private final Optional<String> name;
    private final Optional<String> productExternalId;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private CrmDealResponseData(String accountId, String arr, Optional<String> companyExternalId, OffsetDateTime createdAt, String dealExternalId, String dealId, String environmentId, String mrr, Optional<String> name, Optional<String> productExternalId, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.arr = arr;
        this.companyExternalId = companyExternalId;
        this.createdAt = createdAt;
        this.dealExternalId = dealExternalId;
        this.dealId = dealId;
        this.environmentId = environmentId;
        this.mrr = mrr;
        this.name = name;
        this.productExternalId = productExternalId;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="arr")
    public String getArr() {
        return this.arr;
    }

    @JsonProperty(value="company_external_id")
    public Optional<String> getCompanyExternalId() {
        return this.companyExternalId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="deal_external_id")
    public String getDealExternalId() {
        return this.dealExternalId;
    }

    @JsonProperty(value="deal_id")
    public String getDealId() {
        return this.dealId;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="mrr")
    public String getMrr() {
        return this.mrr;
    }

    @JsonProperty(value="name")
    public Optional<String> getName() {
        return this.name;
    }

    @JsonProperty(value="product_external_id")
    public Optional<String> getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CrmDealResponseData && this.equalTo((CrmDealResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CrmDealResponseData other) {
        return this.accountId.equals(other.accountId) && this.arr.equals(other.arr) && this.companyExternalId.equals(other.companyExternalId) && this.createdAt.equals(other.createdAt) && this.dealExternalId.equals(other.dealExternalId) && this.dealId.equals(other.dealId) && this.environmentId.equals(other.environmentId) && this.mrr.equals(other.mrr) && this.name.equals(other.name) && this.productExternalId.equals(other.productExternalId) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.arr, this.companyExternalId, this.createdAt, this.dealExternalId, this.dealId, this.environmentId, this.mrr, this.name, this.productExternalId, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    ArrStage,
    CreatedAtStage,
    DealExternalIdStage,
    DealIdStage,
    EnvironmentIdStage,
    MrrStage,
    UpdatedAtStage,
    _FinalStage {
        private String accountId;
        private String arr;
        private OffsetDateTime createdAt;
        private String dealExternalId;
        private String dealId;
        private String environmentId;
        private String mrr;
        private OffsetDateTime updatedAt;
        private Optional<String> productExternalId = Optional.empty();
        private Optional<String> name = Optional.empty();
        private Optional<String> companyExternalId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CrmDealResponseData other) {
            this.accountId(other.getAccountId());
            this.arr(other.getArr());
            this.companyExternalId(other.getCompanyExternalId());
            this.createdAt(other.getCreatedAt());
            this.dealExternalId(other.getDealExternalId());
            this.dealId(other.getDealId());
            this.environmentId(other.getEnvironmentId());
            this.mrr(other.getMrr());
            this.name(other.getName());
            this.productExternalId(other.getProductExternalId());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public ArrStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="arr")
        public CreatedAtStage arr(@NotNull String arr) {
            this.arr = Objects.requireNonNull(arr, "arr must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DealExternalIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="deal_external_id")
        public DealIdStage dealExternalId(@NotNull String dealExternalId) {
            this.dealExternalId = Objects.requireNonNull(dealExternalId, "dealExternalId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="deal_id")
        public EnvironmentIdStage dealId(@NotNull String dealId) {
            this.dealId = Objects.requireNonNull(dealId, "dealId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public MrrStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="mrr")
        public UpdatedAtStage mrr(@NotNull String mrr) {
            this.mrr = Objects.requireNonNull(mrr, "mrr must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage productExternalId(String productExternalId) {
            this.productExternalId = Optional.ofNullable(productExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id", nulls=Nulls.SKIP)
        public _FinalStage productExternalId(Optional<String> productExternalId) {
            this.productExternalId = productExternalId;
            return this;
        }

        @Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @Override
        @JsonSetter(value="name", nulls=Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @Override
        public _FinalStage companyExternalId(String companyExternalId) {
            this.companyExternalId = Optional.ofNullable(companyExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="company_external_id", nulls=Nulls.SKIP)
        public _FinalStage companyExternalId(Optional<String> companyExternalId) {
            this.companyExternalId = companyExternalId;
            return this;
        }

        @Override
        public CrmDealResponseData build() {
            return new CrmDealResponseData(this.accountId, this.arr, this.companyExternalId, this.createdAt, this.dealExternalId, this.dealId, this.environmentId, this.mrr, this.name, this.productExternalId, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CrmDealResponseData build();

        public _FinalStage companyExternalId(Optional<String> var1);

        public _FinalStage companyExternalId(String var1);

        public _FinalStage name(Optional<String> var1);

        public _FinalStage name(String var1);

        public _FinalStage productExternalId(Optional<String> var1);

        public _FinalStage productExternalId(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface MrrStage {
        public UpdatedAtStage mrr(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public MrrStage environmentId(@NotNull String var1);
    }

    public static interface DealIdStage {
        public EnvironmentIdStage dealId(@NotNull String var1);
    }

    public static interface DealExternalIdStage {
        public DealIdStage dealExternalId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public DealExternalIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface ArrStage {
        public CreatedAtStage arr(@NotNull String var1);
    }

    public static interface AccountIdStage {
        public ArrStage accountId(@NotNull String var1);

        public Builder from(CrmDealResponseData var1);
    }
}

