/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class CrmLineItemResponseData {
    private final String accountId;
    private final OffsetDateTime createdAt;
    private final Optional<String> dealId;
    private final String environmentId;
    private final Optional<String> productExternalId;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private CrmLineItemResponseData(String accountId, OffsetDateTime createdAt, Optional<String> dealId, String environmentId, Optional<String> productExternalId, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.dealId = dealId;
        this.environmentId = environmentId;
        this.productExternalId = productExternalId;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="account_id")
    public String getAccountId() {
        return this.accountId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="deal_id")
    public Optional<String> getDealId() {
        return this.dealId;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="product_external_id")
    public Optional<String> getProductExternalId() {
        return this.productExternalId;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof CrmLineItemResponseData && this.equalTo((CrmLineItemResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CrmLineItemResponseData other) {
        return this.accountId.equals(other.accountId) && this.createdAt.equals(other.createdAt) && this.dealId.equals(other.dealId) && this.environmentId.equals(other.environmentId) && this.productExternalId.equals(other.productExternalId) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.createdAt, this.dealId, this.environmentId, this.productExternalId, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccountIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    UpdatedAtStage,
    _FinalStage {
        private String accountId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private OffsetDateTime updatedAt;
        private Optional<String> productExternalId = Optional.empty();
        private Optional<String> dealId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(CrmLineItemResponseData other) {
            this.accountId(other.getAccountId());
            this.createdAt(other.getCreatedAt());
            this.dealId(other.getDealId());
            this.environmentId(other.getEnvironmentId());
            this.productExternalId(other.getProductExternalId());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public UpdatedAtStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage productExternalId(String productExternalId) {
            this.productExternalId = Optional.ofNullable(productExternalId);
            return this;
        }

        @Override
        @JsonSetter(value="product_external_id", nulls=Nulls.SKIP)
        public _FinalStage productExternalId(Optional<String> productExternalId) {
            this.productExternalId = productExternalId;
            return this;
        }

        @Override
        public _FinalStage dealId(String dealId) {
            this.dealId = Optional.ofNullable(dealId);
            return this;
        }

        @Override
        @JsonSetter(value="deal_id", nulls=Nulls.SKIP)
        public _FinalStage dealId(Optional<String> dealId) {
            this.dealId = dealId;
            return this;
        }

        @Override
        public CrmLineItemResponseData build() {
            return new CrmLineItemResponseData(this.accountId, this.createdAt, this.dealId, this.environmentId, this.productExternalId, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public CrmLineItemResponseData build();

        public _FinalStage dealId(Optional<String> var1);

        public _FinalStage dealId(String var1);

        public _FinalStage productExternalId(Optional<String> var1);

        public _FinalStage productExternalId(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface EnvironmentIdStage {
        public UpdatedAtStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface AccountIdStage {
        public CreatedAtStage accountId(@NotNull String var1);

        public Builder from(CrmLineItemResponseData var1);
    }
}

