/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EntityKeyDefinitionResponseData {
    private final OffsetDateTime createdAt;
    private final String entityType;
    private final String id;
    private final String key;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private EntityKeyDefinitionResponseData(OffsetDateTime createdAt, String entityType, String id, String key, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.entityType = entityType;
        this.id = id;
        this.key = key;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="entity_type")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EntityKeyDefinitionResponseData && this.equalTo((EntityKeyDefinitionResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EntityKeyDefinitionResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.entityType.equals(other.entityType) && this.id.equals(other.id) && this.key.equals(other.key) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.entityType, this.id, this.key, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    EntityTypeStage,
    IdStage,
    KeyStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String entityType;
        private String id;
        private String key;
        private OffsetDateTime updatedAt;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EntityKeyDefinitionResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.entityType(other.getEntityType());
            this.id(other.getId());
            this.key(other.getKey());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EntityTypeStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entity_type")
        public IdStage entityType(@NotNull String entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public KeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public UpdatedAtStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public EntityKeyDefinitionResponseData build() {
            return new EntityKeyDefinitionResponseData(this.createdAt, this.entityType, this.id, this.key, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EntityKeyDefinitionResponseData build();
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface KeyStage {
        public UpdatedAtStage key(@NotNull String var1);
    }

    public static interface IdStage {
        public KeyStage id(@NotNull String var1);
    }

    public static interface EntityTypeStage {
        public IdStage entityType(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EntityTypeStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(EntityKeyDefinitionResponseData var1);
    }
}

