/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EntityKeyResponseData {
    private final OffsetDateTime createdAt;
    private final String definitionId;
    private final String entityId;
    private final String entityType;
    private final String environmentId;
    private final String id;
    private final String key;
    private final OffsetDateTime updatedAt;
    private final String value;
    private final Map<String, Object> additionalProperties;

    private EntityKeyResponseData(OffsetDateTime createdAt, String definitionId, String entityId, String entityType, String environmentId, String id, String key, OffsetDateTime updatedAt, String value, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.definitionId = definitionId;
        this.entityId = entityId;
        this.entityType = entityType;
        this.environmentId = environmentId;
        this.id = id;
        this.key = key;
        this.updatedAt = updatedAt;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="definition_id")
    public String getDefinitionId() {
        return this.definitionId;
    }

    @JsonProperty(value="entity_id")
    public String getEntityId() {
        return this.entityId;
    }

    @JsonProperty(value="entity_type")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="value")
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EntityKeyResponseData && this.equalTo((EntityKeyResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EntityKeyResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.definitionId.equals(other.definitionId) && this.entityId.equals(other.entityId) && this.entityType.equals(other.entityType) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.key.equals(other.key) && this.updatedAt.equals(other.updatedAt) && this.value.equals(other.value);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.definitionId, this.entityId, this.entityType, this.environmentId, this.id, this.key, this.updatedAt, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    DefinitionIdStage,
    EntityIdStage,
    EntityTypeStage,
    EnvironmentIdStage,
    IdStage,
    KeyStage,
    UpdatedAtStage,
    ValueStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String definitionId;
        private String entityId;
        private String entityType;
        private String environmentId;
        private String id;
        private String key;
        private OffsetDateTime updatedAt;
        private String value;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EntityKeyResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.definitionId(other.getDefinitionId());
            this.entityId(other.getEntityId());
            this.entityType(other.getEntityType());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.key(other.getKey());
            this.updatedAt(other.getUpdatedAt());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DefinitionIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="definition_id")
        public EntityIdStage definitionId(@NotNull String definitionId) {
            this.definitionId = Objects.requireNonNull(definitionId, "definitionId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entity_id")
        public EntityTypeStage entityId(@NotNull String entityId) {
            this.entityId = Objects.requireNonNull(entityId, "entityId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entity_type")
        public EnvironmentIdStage entityType(@NotNull String entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public KeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="key")
        public UpdatedAtStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public ValueStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @Override
        public EntityKeyResponseData build() {
            return new EntityKeyResponseData(this.createdAt, this.definitionId, this.entityId, this.entityType, this.environmentId, this.id, this.key, this.updatedAt, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EntityKeyResponseData build();
    }

    public static interface ValueStage {
        public _FinalStage value(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public ValueStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface KeyStage {
        public UpdatedAtStage key(@NotNull String var1);
    }

    public static interface IdStage {
        public KeyStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface EntityTypeStage {
        public EnvironmentIdStage entityType(@NotNull String var1);
    }

    public static interface EntityIdStage {
        public EntityTypeStage entityId(@NotNull String var1);
    }

    public static interface DefinitionIdStage {
        public EntityIdStage definitionId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public DefinitionIdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(EntityKeyResponseData var1);
    }
}

