/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventBodyFlagCheck {
    private final Optional<String> companyId;
    private final Optional<String> error;
    private final Optional<String> flagId;
    private final String flagKey;
    private final String reason;
    private final Optional<Map<String, String>> reqCompany;
    private final Optional<Map<String, String>> reqUser;
    private final Optional<String> ruleId;
    private final Optional<String> userId;
    private final boolean value;
    private final Map<String, Object> additionalProperties;

    private EventBodyFlagCheck(Optional<String> companyId, Optional<String> error, Optional<String> flagId, String flagKey, String reason, Optional<Map<String, String>> reqCompany, Optional<Map<String, String>> reqUser, Optional<String> ruleId, Optional<String> userId, boolean value, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.error = error;
        this.flagId = flagId;
        this.flagKey = flagKey;
        this.reason = reason;
        this.reqCompany = reqCompany;
        this.reqUser = reqUser;
        this.ruleId = ruleId;
        this.userId = userId;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="error")
    public Optional<String> getError() {
        return this.error;
    }

    @JsonProperty(value="flag_id")
    public Optional<String> getFlagId() {
        return this.flagId;
    }

    @JsonProperty(value="flag_key")
    public String getFlagKey() {
        return this.flagKey;
    }

    @JsonProperty(value="reason")
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="req_company")
    public Optional<Map<String, String>> getReqCompany() {
        return this.reqCompany;
    }

    @JsonProperty(value="req_user")
    public Optional<Map<String, String>> getReqUser() {
        return this.reqUser;
    }

    @JsonProperty(value="rule_id")
    public Optional<String> getRuleId() {
        return this.ruleId;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    @JsonProperty(value="value")
    public boolean getValue() {
        return this.value;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventBodyFlagCheck && this.equalTo((EventBodyFlagCheck)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventBodyFlagCheck other) {
        return this.companyId.equals(other.companyId) && this.error.equals(other.error) && this.flagId.equals(other.flagId) && this.flagKey.equals(other.flagKey) && this.reason.equals(other.reason) && this.reqCompany.equals(other.reqCompany) && this.reqUser.equals(other.reqUser) && this.ruleId.equals(other.ruleId) && this.userId.equals(other.userId) && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.companyId, this.error, this.flagId, this.flagKey, this.reason, this.reqCompany, this.reqUser, this.ruleId, this.userId, this.value);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FlagKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements FlagKeyStage,
    ReasonStage,
    ValueStage,
    _FinalStage {
        private String flagKey;
        private String reason;
        private boolean value;
        private Optional<String> userId = Optional.empty();
        private Optional<String> ruleId = Optional.empty();
        private Optional<Map<String, String>> reqUser = Optional.empty();
        private Optional<Map<String, String>> reqCompany = Optional.empty();
        private Optional<String> flagId = Optional.empty();
        private Optional<String> error = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EventBodyFlagCheck other) {
            this.companyId(other.getCompanyId());
            this.error(other.getError());
            this.flagId(other.getFlagId());
            this.flagKey(other.getFlagKey());
            this.reason(other.getReason());
            this.reqCompany(other.getReqCompany());
            this.reqUser(other.getReqUser());
            this.ruleId(other.getRuleId());
            this.userId(other.getUserId());
            this.value(other.getValue());
            return this;
        }

        @Override
        @JsonSetter(value="flag_key")
        public ReasonStage flagKey(@NotNull String flagKey) {
            this.flagKey = Objects.requireNonNull(flagKey, "flagKey must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="reason")
        public ValueStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public _FinalStage ruleId(String ruleId) {
            this.ruleId = Optional.ofNullable(ruleId);
            return this;
        }

        @Override
        @JsonSetter(value="rule_id", nulls=Nulls.SKIP)
        public _FinalStage ruleId(Optional<String> ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        @Override
        public _FinalStage reqUser(Map<String, String> reqUser) {
            this.reqUser = Optional.ofNullable(reqUser);
            return this;
        }

        @Override
        @JsonSetter(value="req_user", nulls=Nulls.SKIP)
        public _FinalStage reqUser(Optional<Map<String, String>> reqUser) {
            this.reqUser = reqUser;
            return this;
        }

        @Override
        public _FinalStage reqCompany(Map<String, String> reqCompany) {
            this.reqCompany = Optional.ofNullable(reqCompany);
            return this;
        }

        @Override
        @JsonSetter(value="req_company", nulls=Nulls.SKIP)
        public _FinalStage reqCompany(Optional<Map<String, String>> reqCompany) {
            this.reqCompany = reqCompany;
            return this;
        }

        @Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @Override
        @JsonSetter(value="flag_id", nulls=Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @Override
        public _FinalStage error(String error) {
            this.error = Optional.ofNullable(error);
            return this;
        }

        @Override
        @JsonSetter(value="error", nulls=Nulls.SKIP)
        public _FinalStage error(Optional<String> error) {
            this.error = error;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public EventBodyFlagCheck build() {
            return new EventBodyFlagCheck(this.companyId, this.error, this.flagId, this.flagKey, this.reason, this.reqCompany, this.reqUser, this.ruleId, this.userId, this.value, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EventBodyFlagCheck build();

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage error(Optional<String> var1);

        public _FinalStage error(String var1);

        public _FinalStage flagId(Optional<String> var1);

        public _FinalStage flagId(String var1);

        public _FinalStage reqCompany(Optional<Map<String, String>> var1);

        public _FinalStage reqCompany(Map<String, String> var1);

        public _FinalStage reqUser(Optional<Map<String, String>> var1);

        public _FinalStage reqUser(Map<String, String> var1);

        public _FinalStage ruleId(Optional<String> var1);

        public _FinalStage ruleId(String var1);

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);
    }

    public static interface ValueStage {
        public _FinalStage value(boolean var1);
    }

    public static interface ReasonStage {
        public ValueStage reason(@NotNull String var1);
    }

    public static interface FlagKeyStage {
        public ReasonStage flagKey(@NotNull String var1);

        public Builder from(EventBodyFlagCheck var1);
    }
}

