/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventBodyTrack {
    private final Optional<Map<String, String>> company;
    private final String event;
    private final Optional<Integer> quantity;
    private final Optional<Map<String, JsonNode>> traits;
    private final Optional<Map<String, String>> user;
    private final Map<String, Object> additionalProperties;

    private EventBodyTrack(Optional<Map<String, String>> company, String event, Optional<Integer> quantity, Optional<Map<String, JsonNode>> traits, Optional<Map<String, String>> user, Map<String, Object> additionalProperties) {
        this.company = company;
        this.event = event;
        this.quantity = quantity;
        this.traits = traits;
        this.user = user;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company")
    public Optional<Map<String, String>> getCompany() {
        return this.company;
    }

    @JsonProperty(value="event")
    public String getEvent() {
        return this.event;
    }

    @JsonProperty(value="quantity")
    public Optional<Integer> getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="traits")
    public Optional<Map<String, JsonNode>> getTraits() {
        return this.traits;
    }

    @JsonProperty(value="user")
    public Optional<Map<String, String>> getUser() {
        return this.user;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventBodyTrack && this.equalTo((EventBodyTrack)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventBodyTrack other) {
        return this.company.equals(other.company) && this.event.equals(other.event) && this.quantity.equals(other.quantity) && this.traits.equals(other.traits) && this.user.equals(other.user);
    }

    public int hashCode() {
        return Objects.hash(this.company, this.event, this.quantity, this.traits, this.user);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EventStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements EventStage,
    _FinalStage {
        private String event;
        private Optional<Map<String, String>> user = Optional.empty();
        private Optional<Map<String, JsonNode>> traits = Optional.empty();
        private Optional<Integer> quantity = Optional.empty();
        private Optional<Map<String, String>> company = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EventBodyTrack other) {
            this.company(other.getCompany());
            this.event(other.getEvent());
            this.quantity(other.getQuantity());
            this.traits(other.getTraits());
            this.user(other.getUser());
            return this;
        }

        @Override
        @JsonSetter(value="event")
        public _FinalStage event(@NotNull String event) {
            this.event = Objects.requireNonNull(event, "event must not be null");
            return this;
        }

        @Override
        public _FinalStage user(Map<String, String> user) {
            this.user = Optional.ofNullable(user);
            return this;
        }

        @Override
        @JsonSetter(value="user", nulls=Nulls.SKIP)
        public _FinalStage user(Optional<Map<String, String>> user) {
            this.user = user;
            return this;
        }

        @Override
        public _FinalStage traits(Map<String, JsonNode> traits) {
            this.traits = Optional.ofNullable(traits);
            return this;
        }

        @Override
        @JsonSetter(value="traits", nulls=Nulls.SKIP)
        public _FinalStage traits(Optional<Map<String, JsonNode>> traits) {
            this.traits = traits;
            return this;
        }

        @Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @Override
        @JsonSetter(value="quantity", nulls=Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        public _FinalStage company(Map<String, String> company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<Map<String, String>> company) {
            this.company = company;
            return this;
        }

        @Override
        public EventBodyTrack build() {
            return new EventBodyTrack(this.company, this.event, this.quantity, this.traits, this.user, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EventBodyTrack build();

        public _FinalStage company(Optional<Map<String, String>> var1);

        public _FinalStage company(Map<String, String> var1);

        public _FinalStage quantity(Optional<Integer> var1);

        public _FinalStage quantity(Integer var1);

        public _FinalStage traits(Optional<Map<String, JsonNode>> var1);

        public _FinalStage traits(Map<String, JsonNode> var1);

        public _FinalStage user(Optional<Map<String, String>> var1);

        public _FinalStage user(Map<String, String> var1);
    }

    public static interface EventStage {
        public _FinalStage event(@NotNull String var1);

        public Builder from(EventBodyTrack var1);
    }
}

