/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.PreviewObject;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventDetailResponseData {
    private final Optional<String> apiKey;
    private final Map<String, JsonNode> body;
    private final String bodyPreview;
    private final OffsetDateTime capturedAt;
    private final Optional<PreviewObject> company;
    private final Optional<String> companyId;
    private final Optional<OffsetDateTime> enrichedAt;
    private final Optional<String> environmentId;
    private final Optional<String> errorMessage;
    private final List<String> featureIds;
    private final List<PreviewObject> features;
    private final String id;
    private final Optional<OffsetDateTime> loadedAt;
    private final Optional<OffsetDateTime> processedAt;
    private final int quantity;
    private final Optional<OffsetDateTime> sentAt;
    private final String status;
    private final Optional<String> subtype;
    private final String type;
    private final OffsetDateTime updatedAt;
    private final Optional<PreviewObject> user;
    private final Optional<String> userId;
    private final Map<String, Object> additionalProperties;

    private EventDetailResponseData(Optional<String> apiKey, Map<String, JsonNode> body, String bodyPreview, OffsetDateTime capturedAt, Optional<PreviewObject> company, Optional<String> companyId, Optional<OffsetDateTime> enrichedAt, Optional<String> environmentId, Optional<String> errorMessage, List<String> featureIds, List<PreviewObject> features, String id, Optional<OffsetDateTime> loadedAt, Optional<OffsetDateTime> processedAt, int quantity, Optional<OffsetDateTime> sentAt, String status, Optional<String> subtype, String type, OffsetDateTime updatedAt, Optional<PreviewObject> user, Optional<String> userId, Map<String, Object> additionalProperties) {
        this.apiKey = apiKey;
        this.body = body;
        this.bodyPreview = bodyPreview;
        this.capturedAt = capturedAt;
        this.company = company;
        this.companyId = companyId;
        this.enrichedAt = enrichedAt;
        this.environmentId = environmentId;
        this.errorMessage = errorMessage;
        this.featureIds = featureIds;
        this.features = features;
        this.id = id;
        this.loadedAt = loadedAt;
        this.processedAt = processedAt;
        this.quantity = quantity;
        this.sentAt = sentAt;
        this.status = status;
        this.subtype = subtype;
        this.type = type;
        this.updatedAt = updatedAt;
        this.user = user;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="api_key")
    public Optional<String> getApiKey() {
        return this.apiKey;
    }

    @JsonProperty(value="body")
    public Map<String, JsonNode> getBody() {
        return this.body;
    }

    @JsonProperty(value="body_preview")
    public String getBodyPreview() {
        return this.bodyPreview;
    }

    @JsonProperty(value="captured_at")
    public OffsetDateTime getCapturedAt() {
        return this.capturedAt;
    }

    @JsonProperty(value="company")
    public Optional<PreviewObject> getCompany() {
        return this.company;
    }

    @JsonProperty(value="company_id")
    public Optional<String> getCompanyId() {
        return this.companyId;
    }

    @JsonProperty(value="enriched_at")
    public Optional<OffsetDateTime> getEnrichedAt() {
        return this.enrichedAt;
    }

    @JsonProperty(value="environment_id")
    public Optional<String> getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="error_message")
    public Optional<String> getErrorMessage() {
        return this.errorMessage;
    }

    @JsonProperty(value="feature_ids")
    public List<String> getFeatureIds() {
        return this.featureIds;
    }

    @JsonProperty(value="features")
    public List<PreviewObject> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="loaded_at")
    public Optional<OffsetDateTime> getLoadedAt() {
        return this.loadedAt;
    }

    @JsonProperty(value="processed_at")
    public Optional<OffsetDateTime> getProcessedAt() {
        return this.processedAt;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="sent_at")
    public Optional<OffsetDateTime> getSentAt() {
        return this.sentAt;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="subtype")
    public Optional<String> getSubtype() {
        return this.subtype;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="user")
    public Optional<PreviewObject> getUser() {
        return this.user;
    }

    @JsonProperty(value="user_id")
    public Optional<String> getUserId() {
        return this.userId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventDetailResponseData && this.equalTo((EventDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventDetailResponseData other) {
        return this.apiKey.equals(other.apiKey) && this.body.equals(other.body) && this.bodyPreview.equals(other.bodyPreview) && this.capturedAt.equals(other.capturedAt) && this.company.equals(other.company) && this.companyId.equals(other.companyId) && this.enrichedAt.equals(other.enrichedAt) && this.environmentId.equals(other.environmentId) && this.errorMessage.equals(other.errorMessage) && this.featureIds.equals(other.featureIds) && this.features.equals(other.features) && this.id.equals(other.id) && this.loadedAt.equals(other.loadedAt) && this.processedAt.equals(other.processedAt) && this.quantity == other.quantity && this.sentAt.equals(other.sentAt) && this.status.equals(other.status) && this.subtype.equals(other.subtype) && this.type.equals(other.type) && this.updatedAt.equals(other.updatedAt) && this.user.equals(other.user) && this.userId.equals(other.userId);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.body, this.bodyPreview, this.capturedAt, this.company, this.companyId, this.enrichedAt, this.environmentId, this.errorMessage, this.featureIds, this.features, this.id, this.loadedAt, this.processedAt, this.quantity, this.sentAt, this.status, this.subtype, this.type, this.updatedAt, this.user, this.userId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyPreviewStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements BodyPreviewStage,
    CapturedAtStage,
    IdStage,
    QuantityStage,
    StatusStage,
    TypeStage,
    UpdatedAtStage,
    _FinalStage {
        private String bodyPreview;
        private OffsetDateTime capturedAt;
        private String id;
        private int quantity;
        private String status;
        private String type;
        private OffsetDateTime updatedAt;
        private Optional<String> userId = Optional.empty();
        private Optional<PreviewObject> user = Optional.empty();
        private Optional<String> subtype = Optional.empty();
        private Optional<OffsetDateTime> sentAt = Optional.empty();
        private Optional<OffsetDateTime> processedAt = Optional.empty();
        private Optional<OffsetDateTime> loadedAt = Optional.empty();
        private List<PreviewObject> features = new ArrayList<PreviewObject>();
        private List<String> featureIds = new ArrayList<String>();
        private Optional<String> errorMessage = Optional.empty();
        private Optional<String> environmentId = Optional.empty();
        private Optional<OffsetDateTime> enrichedAt = Optional.empty();
        private Optional<String> companyId = Optional.empty();
        private Optional<PreviewObject> company = Optional.empty();
        private Map<String, JsonNode> body = new LinkedHashMap<String, JsonNode>();
        private Optional<String> apiKey = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EventDetailResponseData other) {
            this.apiKey(other.getApiKey());
            this.body(other.getBody());
            this.bodyPreview(other.getBodyPreview());
            this.capturedAt(other.getCapturedAt());
            this.company(other.getCompany());
            this.companyId(other.getCompanyId());
            this.enrichedAt(other.getEnrichedAt());
            this.environmentId(other.getEnvironmentId());
            this.errorMessage(other.getErrorMessage());
            this.featureIds(other.getFeatureIds());
            this.features(other.getFeatures());
            this.id(other.getId());
            this.loadedAt(other.getLoadedAt());
            this.processedAt(other.getProcessedAt());
            this.quantity(other.getQuantity());
            this.sentAt(other.getSentAt());
            this.status(other.getStatus());
            this.subtype(other.getSubtype());
            this.type(other.getType());
            this.updatedAt(other.getUpdatedAt());
            this.user(other.getUser());
            this.userId(other.getUserId());
            return this;
        }

        @Override
        @JsonSetter(value="body_preview")
        public CapturedAtStage bodyPreview(@NotNull String bodyPreview) {
            this.bodyPreview = Objects.requireNonNull(bodyPreview, "bodyPreview must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="captured_at")
        public IdStage capturedAt(@NotNull OffsetDateTime capturedAt) {
            this.capturedAt = Objects.requireNonNull(capturedAt, "capturedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public QuantityStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="quantity")
        public StatusStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public TypeStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public UpdatedAtStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @Override
        @JsonSetter(value="user_id", nulls=Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @Override
        public _FinalStage user(PreviewObject user) {
            this.user = Optional.ofNullable(user);
            return this;
        }

        @Override
        @JsonSetter(value="user", nulls=Nulls.SKIP)
        public _FinalStage user(Optional<PreviewObject> user) {
            this.user = user;
            return this;
        }

        @Override
        public _FinalStage subtype(String subtype) {
            this.subtype = Optional.ofNullable(subtype);
            return this;
        }

        @Override
        @JsonSetter(value="subtype", nulls=Nulls.SKIP)
        public _FinalStage subtype(Optional<String> subtype) {
            this.subtype = subtype;
            return this;
        }

        @Override
        public _FinalStage sentAt(OffsetDateTime sentAt) {
            this.sentAt = Optional.ofNullable(sentAt);
            return this;
        }

        @Override
        @JsonSetter(value="sent_at", nulls=Nulls.SKIP)
        public _FinalStage sentAt(Optional<OffsetDateTime> sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        @Override
        public _FinalStage processedAt(OffsetDateTime processedAt) {
            this.processedAt = Optional.ofNullable(processedAt);
            return this;
        }

        @Override
        @JsonSetter(value="processed_at", nulls=Nulls.SKIP)
        public _FinalStage processedAt(Optional<OffsetDateTime> processedAt) {
            this.processedAt = processedAt;
            return this;
        }

        @Override
        public _FinalStage loadedAt(OffsetDateTime loadedAt) {
            this.loadedAt = Optional.ofNullable(loadedAt);
            return this;
        }

        @Override
        @JsonSetter(value="loaded_at", nulls=Nulls.SKIP)
        public _FinalStage loadedAt(Optional<OffsetDateTime> loadedAt) {
            this.loadedAt = loadedAt;
            return this;
        }

        @Override
        public _FinalStage addAllFeatures(List<PreviewObject> features) {
            this.features.addAll(features);
            return this;
        }

        @Override
        public _FinalStage addFeatures(PreviewObject features) {
            this.features.add(features);
            return this;
        }

        @Override
        @JsonSetter(value="features", nulls=Nulls.SKIP)
        public _FinalStage features(List<PreviewObject> features) {
            this.features.clear();
            this.features.addAll(features);
            return this;
        }

        @Override
        public _FinalStage addAllFeatureIds(List<String> featureIds) {
            this.featureIds.addAll(featureIds);
            return this;
        }

        @Override
        public _FinalStage addFeatureIds(String featureIds) {
            this.featureIds.add(featureIds);
            return this;
        }

        @Override
        @JsonSetter(value="feature_ids", nulls=Nulls.SKIP)
        public _FinalStage featureIds(List<String> featureIds) {
            this.featureIds.clear();
            this.featureIds.addAll(featureIds);
            return this;
        }

        @Override
        public _FinalStage errorMessage(String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @Override
        @JsonSetter(value="error_message", nulls=Nulls.SKIP)
        public _FinalStage errorMessage(Optional<String> errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @Override
        @JsonSetter(value="environment_id", nulls=Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Override
        public _FinalStage enrichedAt(OffsetDateTime enrichedAt) {
            this.enrichedAt = Optional.ofNullable(enrichedAt);
            return this;
        }

        @Override
        @JsonSetter(value="enriched_at", nulls=Nulls.SKIP)
        public _FinalStage enrichedAt(Optional<OffsetDateTime> enrichedAt) {
            this.enrichedAt = enrichedAt;
            return this;
        }

        @Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @Override
        @JsonSetter(value="company_id", nulls=Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @Override
        public _FinalStage company(PreviewObject company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<PreviewObject> company) {
            this.company = company;
            return this;
        }

        @Override
        public _FinalStage body(String key, JsonNode value) {
            this.body.put(key, value);
            return this;
        }

        @Override
        public _FinalStage putAllBody(Map<String, JsonNode> body) {
            this.body.putAll(body);
            return this;
        }

        @Override
        @JsonSetter(value="body", nulls=Nulls.SKIP)
        public _FinalStage body(Map<String, JsonNode> body) {
            this.body.clear();
            this.body.putAll(body);
            return this;
        }

        @Override
        public _FinalStage apiKey(String apiKey) {
            this.apiKey = Optional.ofNullable(apiKey);
            return this;
        }

        @Override
        @JsonSetter(value="api_key", nulls=Nulls.SKIP)
        public _FinalStage apiKey(Optional<String> apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public EventDetailResponseData build() {
            return new EventDetailResponseData(this.apiKey, this.body, this.bodyPreview, this.capturedAt, this.company, this.companyId, this.enrichedAt, this.environmentId, this.errorMessage, this.featureIds, this.features, this.id, this.loadedAt, this.processedAt, this.quantity, this.sentAt, this.status, this.subtype, this.type, this.updatedAt, this.user, this.userId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EventDetailResponseData build();

        public _FinalStage apiKey(Optional<String> var1);

        public _FinalStage apiKey(String var1);

        public _FinalStage body(Map<String, JsonNode> var1);

        public _FinalStage putAllBody(Map<String, JsonNode> var1);

        public _FinalStage body(String var1, JsonNode var2);

        public _FinalStage company(Optional<PreviewObject> var1);

        public _FinalStage company(PreviewObject var1);

        public _FinalStage companyId(Optional<String> var1);

        public _FinalStage companyId(String var1);

        public _FinalStage enrichedAt(Optional<OffsetDateTime> var1);

        public _FinalStage enrichedAt(OffsetDateTime var1);

        public _FinalStage environmentId(Optional<String> var1);

        public _FinalStage environmentId(String var1);

        public _FinalStage errorMessage(Optional<String> var1);

        public _FinalStage errorMessage(String var1);

        public _FinalStage featureIds(List<String> var1);

        public _FinalStage addFeatureIds(String var1);

        public _FinalStage addAllFeatureIds(List<String> var1);

        public _FinalStage features(List<PreviewObject> var1);

        public _FinalStage addFeatures(PreviewObject var1);

        public _FinalStage addAllFeatures(List<PreviewObject> var1);

        public _FinalStage loadedAt(Optional<OffsetDateTime> var1);

        public _FinalStage loadedAt(OffsetDateTime var1);

        public _FinalStage processedAt(Optional<OffsetDateTime> var1);

        public _FinalStage processedAt(OffsetDateTime var1);

        public _FinalStage sentAt(Optional<OffsetDateTime> var1);

        public _FinalStage sentAt(OffsetDateTime var1);

        public _FinalStage subtype(Optional<String> var1);

        public _FinalStage subtype(String var1);

        public _FinalStage user(Optional<PreviewObject> var1);

        public _FinalStage user(PreviewObject var1);

        public _FinalStage userId(Optional<String> var1);

        public _FinalStage userId(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface TypeStage {
        public UpdatedAtStage type(@NotNull String var1);
    }

    public static interface StatusStage {
        public TypeStage status(@NotNull String var1);
    }

    public static interface QuantityStage {
        public StatusStage quantity(int var1);
    }

    public static interface IdStage {
        public QuantityStage id(@NotNull String var1);
    }

    public static interface CapturedAtStage {
        public IdStage capturedAt(@NotNull OffsetDateTime var1);
    }

    public static interface BodyPreviewStage {
        public CapturedAtStage bodyPreview(@NotNull String var1);

        public Builder from(EventDetailResponseData var1);
    }
}

