/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class EventSummaryResponseData {
    private final int companyCount;
    private final String environmentId;
    private final int eventCount;
    private final String eventSubtype;
    private final Optional<OffsetDateTime> lastSeenAt;
    private final int userCount;
    private final Map<String, Object> additionalProperties;

    private EventSummaryResponseData(int companyCount, String environmentId, int eventCount, String eventSubtype, Optional<OffsetDateTime> lastSeenAt, int userCount, Map<String, Object> additionalProperties) {
        this.companyCount = companyCount;
        this.environmentId = environmentId;
        this.eventCount = eventCount;
        this.eventSubtype = eventSubtype;
        this.lastSeenAt = lastSeenAt;
        this.userCount = userCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_count")
    public int getCompanyCount() {
        return this.companyCount;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="event_count")
    public int getEventCount() {
        return this.eventCount;
    }

    @JsonProperty(value="event_subtype")
    public String getEventSubtype() {
        return this.eventSubtype;
    }

    @JsonProperty(value="last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @JsonProperty(value="user_count")
    public int getUserCount() {
        return this.userCount;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof EventSummaryResponseData && this.equalTo((EventSummaryResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventSummaryResponseData other) {
        return this.companyCount == other.companyCount && this.environmentId.equals(other.environmentId) && this.eventCount == other.eventCount && this.eventSubtype.equals(other.eventSubtype) && this.lastSeenAt.equals(other.lastSeenAt) && this.userCount == other.userCount;
    }

    public int hashCode() {
        return Objects.hash(this.companyCount, this.environmentId, this.eventCount, this.eventSubtype, this.lastSeenAt, this.userCount);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyCountStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CompanyCountStage,
    EnvironmentIdStage,
    EventCountStage,
    EventSubtypeStage,
    UserCountStage,
    _FinalStage {
        private int companyCount;
        private String environmentId;
        private int eventCount;
        private String eventSubtype;
        private int userCount;
        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(EventSummaryResponseData other) {
            this.companyCount(other.getCompanyCount());
            this.environmentId(other.getEnvironmentId());
            this.eventCount(other.getEventCount());
            this.eventSubtype(other.getEventSubtype());
            this.lastSeenAt(other.getLastSeenAt());
            this.userCount(other.getUserCount());
            return this;
        }

        @Override
        @JsonSetter(value="company_count")
        public EnvironmentIdStage companyCount(int companyCount) {
            this.companyCount = companyCount;
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public EventCountStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="event_count")
        public EventSubtypeStage eventCount(int eventCount) {
            this.eventCount = eventCount;
            return this;
        }

        @Override
        @JsonSetter(value="event_subtype")
        public UserCountStage eventSubtype(@NotNull String eventSubtype) {
            this.eventSubtype = Objects.requireNonNull(eventSubtype, "eventSubtype must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="user_count")
        public _FinalStage userCount(int userCount) {
            this.userCount = userCount;
            return this;
        }

        @Override
        public _FinalStage lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @Override
        public EventSummaryResponseData build() {
            return new EventSummaryResponseData(this.companyCount, this.environmentId, this.eventCount, this.eventSubtype, this.lastSeenAt, this.userCount, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public EventSummaryResponseData build();

        public _FinalStage lastSeenAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastSeenAt(OffsetDateTime var1);
    }

    public static interface UserCountStage {
        public _FinalStage userCount(int var1);
    }

    public static interface EventSubtypeStage {
        public UserCountStage eventSubtype(@NotNull String var1);
    }

    public static interface EventCountStage {
        public EventSubtypeStage eventCount(int var1);
    }

    public static interface EnvironmentIdStage {
        public EventCountStage environmentId(@NotNull String var1);
    }

    public static interface CompanyCountStage {
        public EnvironmentIdStage companyCount(int var1);

        public Builder from(EventSummaryResponseData var1);
    }
}

