/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CompanyDetailResponseData;
import com.schematic.api.types.FeatureCompanyResponseDataAllocationType;
import com.schematic.api.types.FeatureDetailResponseData;
import com.schematic.api.types.PlanResponseData;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FeatureCompanyResponseData {
    private final boolean access;
    private final Optional<Integer> allocation;
    private final FeatureCompanyResponseDataAllocationType allocationType;
    private final Optional<CompanyDetailResponseData> company;
    private final Optional<OffsetDateTime> entitlementExpirationDate;
    private final String entitlementId;
    private final String entitlementType;
    private final Optional<FeatureDetailResponseData> feature;
    private final Optional<OffsetDateTime> metricResetAt;
    private final Optional<String> monthReset;
    private final Optional<String> period;
    private final Optional<PlanResponseData> plan;
    private final Optional<Integer> usage;
    private final Map<String, Object> additionalProperties;

    private FeatureCompanyResponseData(boolean access, Optional<Integer> allocation, FeatureCompanyResponseDataAllocationType allocationType, Optional<CompanyDetailResponseData> company, Optional<OffsetDateTime> entitlementExpirationDate, String entitlementId, String entitlementType, Optional<FeatureDetailResponseData> feature, Optional<OffsetDateTime> metricResetAt, Optional<String> monthReset, Optional<String> period, Optional<PlanResponseData> plan, Optional<Integer> usage, Map<String, Object> additionalProperties) {
        this.access = access;
        this.allocation = allocation;
        this.allocationType = allocationType;
        this.company = company;
        this.entitlementExpirationDate = entitlementExpirationDate;
        this.entitlementId = entitlementId;
        this.entitlementType = entitlementType;
        this.feature = feature;
        this.metricResetAt = metricResetAt;
        this.monthReset = monthReset;
        this.period = period;
        this.plan = plan;
        this.usage = usage;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="access")
    public boolean getAccess() {
        return this.access;
    }

    @JsonProperty(value="allocation")
    public Optional<Integer> getAllocation() {
        return this.allocation;
    }

    @JsonProperty(value="allocation_type")
    public FeatureCompanyResponseDataAllocationType getAllocationType() {
        return this.allocationType;
    }

    @JsonProperty(value="company")
    public Optional<CompanyDetailResponseData> getCompany() {
        return this.company;
    }

    @JsonProperty(value="entitlement_expiration_date")
    public Optional<OffsetDateTime> getEntitlementExpirationDate() {
        return this.entitlementExpirationDate;
    }

    @JsonProperty(value="entitlement_id")
    public String getEntitlementId() {
        return this.entitlementId;
    }

    @JsonProperty(value="entitlement_type")
    public String getEntitlementType() {
        return this.entitlementType;
    }

    @JsonProperty(value="feature")
    public Optional<FeatureDetailResponseData> getFeature() {
        return this.feature;
    }

    @JsonProperty(value="metric_reset_at")
    public Optional<OffsetDateTime> getMetricResetAt() {
        return this.metricResetAt;
    }

    @JsonProperty(value="month_reset")
    public Optional<String> getMonthReset() {
        return this.monthReset;
    }

    @JsonProperty(value="period")
    public Optional<String> getPeriod() {
        return this.period;
    }

    @JsonProperty(value="plan")
    public Optional<PlanResponseData> getPlan() {
        return this.plan;
    }

    @JsonProperty(value="usage")
    public Optional<Integer> getUsage() {
        return this.usage;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FeatureCompanyResponseData && this.equalTo((FeatureCompanyResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureCompanyResponseData other) {
        return this.access == other.access && this.allocation.equals(other.allocation) && this.allocationType.equals((Object)other.allocationType) && this.company.equals(other.company) && this.entitlementExpirationDate.equals(other.entitlementExpirationDate) && this.entitlementId.equals(other.entitlementId) && this.entitlementType.equals(other.entitlementType) && this.feature.equals(other.feature) && this.metricResetAt.equals(other.metricResetAt) && this.monthReset.equals(other.monthReset) && this.period.equals(other.period) && this.plan.equals(other.plan) && this.usage.equals(other.usage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.access, this.allocation, this.allocationType, this.company, this.entitlementExpirationDate, this.entitlementId, this.entitlementType, this.feature, this.metricResetAt, this.monthReset, this.period, this.plan, this.usage});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccessStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AccessStage,
    AllocationTypeStage,
    EntitlementIdStage,
    EntitlementTypeStage,
    _FinalStage {
        private boolean access;
        private FeatureCompanyResponseDataAllocationType allocationType;
        private String entitlementId;
        private String entitlementType;
        private Optional<Integer> usage = Optional.empty();
        private Optional<PlanResponseData> plan = Optional.empty();
        private Optional<String> period = Optional.empty();
        private Optional<String> monthReset = Optional.empty();
        private Optional<OffsetDateTime> metricResetAt = Optional.empty();
        private Optional<FeatureDetailResponseData> feature = Optional.empty();
        private Optional<OffsetDateTime> entitlementExpirationDate = Optional.empty();
        private Optional<CompanyDetailResponseData> company = Optional.empty();
        private Optional<Integer> allocation = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FeatureCompanyResponseData other) {
            this.access(other.getAccess());
            this.allocation(other.getAllocation());
            this.allocationType(other.getAllocationType());
            this.company(other.getCompany());
            this.entitlementExpirationDate(other.getEntitlementExpirationDate());
            this.entitlementId(other.getEntitlementId());
            this.entitlementType(other.getEntitlementType());
            this.feature(other.getFeature());
            this.metricResetAt(other.getMetricResetAt());
            this.monthReset(other.getMonthReset());
            this.period(other.getPeriod());
            this.plan(other.getPlan());
            this.usage(other.getUsage());
            return this;
        }

        @Override
        @JsonSetter(value="access")
        public AllocationTypeStage access(boolean access) {
            this.access = access;
            return this;
        }

        @Override
        @JsonSetter(value="allocation_type")
        public EntitlementIdStage allocationType(@NotNull FeatureCompanyResponseDataAllocationType allocationType) {
            this.allocationType = Objects.requireNonNull(allocationType, "allocationType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_id")
        public EntitlementTypeStage entitlementId(@NotNull String entitlementId) {
            this.entitlementId = Objects.requireNonNull(entitlementId, "entitlementId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_type")
        public _FinalStage entitlementType(@NotNull String entitlementType) {
            this.entitlementType = Objects.requireNonNull(entitlementType, "entitlementType must not be null");
            return this;
        }

        @Override
        public _FinalStage usage(Integer usage) {
            this.usage = Optional.ofNullable(usage);
            return this;
        }

        @Override
        @JsonSetter(value="usage", nulls=Nulls.SKIP)
        public _FinalStage usage(Optional<Integer> usage) {
            this.usage = usage;
            return this;
        }

        @Override
        public _FinalStage plan(PlanResponseData plan) {
            this.plan = Optional.ofNullable(plan);
            return this;
        }

        @Override
        @JsonSetter(value="plan", nulls=Nulls.SKIP)
        public _FinalStage plan(Optional<PlanResponseData> plan) {
            this.plan = plan;
            return this;
        }

        @Override
        public _FinalStage period(String period) {
            this.period = Optional.ofNullable(period);
            return this;
        }

        @Override
        @JsonSetter(value="period", nulls=Nulls.SKIP)
        public _FinalStage period(Optional<String> period) {
            this.period = period;
            return this;
        }

        @Override
        public _FinalStage monthReset(String monthReset) {
            this.monthReset = Optional.ofNullable(monthReset);
            return this;
        }

        @Override
        @JsonSetter(value="month_reset", nulls=Nulls.SKIP)
        public _FinalStage monthReset(Optional<String> monthReset) {
            this.monthReset = monthReset;
            return this;
        }

        @Override
        public _FinalStage metricResetAt(OffsetDateTime metricResetAt) {
            this.metricResetAt = Optional.ofNullable(metricResetAt);
            return this;
        }

        @Override
        @JsonSetter(value="metric_reset_at", nulls=Nulls.SKIP)
        public _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt) {
            this.metricResetAt = metricResetAt;
            return this;
        }

        @Override
        public _FinalStage feature(FeatureDetailResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @Override
        @JsonSetter(value="feature", nulls=Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureDetailResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public _FinalStage entitlementExpirationDate(OffsetDateTime entitlementExpirationDate) {
            this.entitlementExpirationDate = Optional.ofNullable(entitlementExpirationDate);
            return this;
        }

        @Override
        @JsonSetter(value="entitlement_expiration_date", nulls=Nulls.SKIP)
        public _FinalStage entitlementExpirationDate(Optional<OffsetDateTime> entitlementExpirationDate) {
            this.entitlementExpirationDate = entitlementExpirationDate;
            return this;
        }

        @Override
        public _FinalStage company(CompanyDetailResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @Override
        @JsonSetter(value="company", nulls=Nulls.SKIP)
        public _FinalStage company(Optional<CompanyDetailResponseData> company) {
            this.company = company;
            return this;
        }

        @Override
        public _FinalStage allocation(Integer allocation) {
            this.allocation = Optional.ofNullable(allocation);
            return this;
        }

        @Override
        @JsonSetter(value="allocation", nulls=Nulls.SKIP)
        public _FinalStage allocation(Optional<Integer> allocation) {
            this.allocation = allocation;
            return this;
        }

        @Override
        public FeatureCompanyResponseData build() {
            return new FeatureCompanyResponseData(this.access, this.allocation, this.allocationType, this.company, this.entitlementExpirationDate, this.entitlementId, this.entitlementType, this.feature, this.metricResetAt, this.monthReset, this.period, this.plan, this.usage, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FeatureCompanyResponseData build();

        public _FinalStage allocation(Optional<Integer> var1);

        public _FinalStage allocation(Integer var1);

        public _FinalStage company(Optional<CompanyDetailResponseData> var1);

        public _FinalStage company(CompanyDetailResponseData var1);

        public _FinalStage entitlementExpirationDate(Optional<OffsetDateTime> var1);

        public _FinalStage entitlementExpirationDate(OffsetDateTime var1);

        public _FinalStage feature(Optional<FeatureDetailResponseData> var1);

        public _FinalStage feature(FeatureDetailResponseData var1);

        public _FinalStage metricResetAt(Optional<OffsetDateTime> var1);

        public _FinalStage metricResetAt(OffsetDateTime var1);

        public _FinalStage monthReset(Optional<String> var1);

        public _FinalStage monthReset(String var1);

        public _FinalStage period(Optional<String> var1);

        public _FinalStage period(String var1);

        public _FinalStage plan(Optional<PlanResponseData> var1);

        public _FinalStage plan(PlanResponseData var1);

        public _FinalStage usage(Optional<Integer> var1);

        public _FinalStage usage(Integer var1);
    }

    public static interface EntitlementTypeStage {
        public _FinalStage entitlementType(@NotNull String var1);
    }

    public static interface EntitlementIdStage {
        public EntitlementTypeStage entitlementId(@NotNull String var1);
    }

    public static interface AllocationTypeStage {
        public EntitlementIdStage allocationType(@NotNull FeatureCompanyResponseDataAllocationType var1);
    }

    public static interface AccessStage {
        public AllocationTypeStage access(boolean var1);

        public Builder from(FeatureCompanyResponseData var1);
    }
}

