/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class FeatureResponseData {
    private final OffsetDateTime createdAt;
    private final String description;
    private final Optional<String> eventSubtype;
    private final String featureType;
    private final String icon;
    private final String id;
    private final Optional<String> lifecyclePhase;
    private final Optional<String> maintainerId;
    private final String name;
    private final Optional<String> traitId;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private FeatureResponseData(OffsetDateTime createdAt, String description, Optional<String> eventSubtype, String featureType, String icon, String id, Optional<String> lifecyclePhase, Optional<String> maintainerId, String name, Optional<String> traitId, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.description = description;
        this.eventSubtype = eventSubtype;
        this.featureType = featureType;
        this.icon = icon;
        this.id = id;
        this.lifecyclePhase = lifecyclePhase;
        this.maintainerId = maintainerId;
        this.name = name;
        this.traitId = traitId;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="event_subtype")
    public Optional<String> getEventSubtype() {
        return this.eventSubtype;
    }

    @JsonProperty(value="feature_type")
    public String getFeatureType() {
        return this.featureType;
    }

    @JsonProperty(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="lifecycle_phase")
    public Optional<String> getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    @JsonProperty(value="maintainer_id")
    public Optional<String> getMaintainerId() {
        return this.maintainerId;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="trait_id")
    public Optional<String> getTraitId() {
        return this.traitId;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof FeatureResponseData && this.equalTo((FeatureResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.description.equals(other.description) && this.eventSubtype.equals(other.eventSubtype) && this.featureType.equals(other.featureType) && this.icon.equals(other.icon) && this.id.equals(other.id) && this.lifecyclePhase.equals(other.lifecyclePhase) && this.maintainerId.equals(other.maintainerId) && this.name.equals(other.name) && this.traitId.equals(other.traitId) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.description, this.eventSubtype, this.featureType, this.icon, this.id, this.lifecyclePhase, this.maintainerId, this.name, this.traitId, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    DescriptionStage,
    FeatureTypeStage,
    IconStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String description;
        private String featureType;
        private String icon;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private Optional<String> traitId = Optional.empty();
        private Optional<String> maintainerId = Optional.empty();
        private Optional<String> lifecyclePhase = Optional.empty();
        private Optional<String> eventSubtype = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(FeatureResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.description(other.getDescription());
            this.eventSubtype(other.getEventSubtype());
            this.featureType(other.getFeatureType());
            this.icon(other.getIcon());
            this.id(other.getId());
            this.lifecyclePhase(other.getLifecyclePhase());
            this.maintainerId(other.getMaintainerId());
            this.name(other.getName());
            this.traitId(other.getTraitId());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public DescriptionStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="description")
        public FeatureTypeStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="feature_type")
        public IconStage featureType(@NotNull String featureType) {
            this.featureType = Objects.requireNonNull(featureType, "featureType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage traitId(String traitId) {
            this.traitId = Optional.ofNullable(traitId);
            return this;
        }

        @Override
        @JsonSetter(value="trait_id", nulls=Nulls.SKIP)
        public _FinalStage traitId(Optional<String> traitId) {
            this.traitId = traitId;
            return this;
        }

        @Override
        public _FinalStage maintainerId(String maintainerId) {
            this.maintainerId = Optional.ofNullable(maintainerId);
            return this;
        }

        @Override
        @JsonSetter(value="maintainer_id", nulls=Nulls.SKIP)
        public _FinalStage maintainerId(Optional<String> maintainerId) {
            this.maintainerId = maintainerId;
            return this;
        }

        @Override
        public _FinalStage lifecyclePhase(String lifecyclePhase) {
            this.lifecyclePhase = Optional.ofNullable(lifecyclePhase);
            return this;
        }

        @Override
        @JsonSetter(value="lifecycle_phase", nulls=Nulls.SKIP)
        public _FinalStage lifecyclePhase(Optional<String> lifecyclePhase) {
            this.lifecyclePhase = lifecyclePhase;
            return this;
        }

        @Override
        public _FinalStage eventSubtype(String eventSubtype) {
            this.eventSubtype = Optional.ofNullable(eventSubtype);
            return this;
        }

        @Override
        @JsonSetter(value="event_subtype", nulls=Nulls.SKIP)
        public _FinalStage eventSubtype(Optional<String> eventSubtype) {
            this.eventSubtype = eventSubtype;
            return this;
        }

        @Override
        public FeatureResponseData build() {
            return new FeatureResponseData(this.createdAt, this.description, this.eventSubtype, this.featureType, this.icon, this.id, this.lifecyclePhase, this.maintainerId, this.name, this.traitId, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public FeatureResponseData build();

        public _FinalStage eventSubtype(Optional<String> var1);

        public _FinalStage eventSubtype(String var1);

        public _FinalStage lifecyclePhase(Optional<String> var1);

        public _FinalStage lifecyclePhase(String var1);

        public _FinalStage maintainerId(Optional<String> var1);

        public _FinalStage maintainerId(String var1);

        public _FinalStage traitId(Optional<String> var1);

        public _FinalStage traitId(String var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface IconStage {
        public IdStage icon(@NotNull String var1);
    }

    public static interface FeatureTypeStage {
        public IconStage featureType(@NotNull String var1);
    }

    public static interface DescriptionStage {
        public FeatureTypeStage description(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public DescriptionStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(FeatureResponseData var1);
    }
}

