/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class PreviewSubscriptionChangeResponseData {
    private final int amountOff;
    private final int dueNow;
    private final int newCharges;
    private final double percentOff;
    private final OffsetDateTime periodStart;
    private final boolean promoCodeApplied;
    private final int proration;
    private final Optional<OffsetDateTime> trialEnd;
    private final Map<String, Object> additionalProperties;

    private PreviewSubscriptionChangeResponseData(int amountOff, int dueNow, int newCharges, double percentOff, OffsetDateTime periodStart, boolean promoCodeApplied, int proration, Optional<OffsetDateTime> trialEnd, Map<String, Object> additionalProperties) {
        this.amountOff = amountOff;
        this.dueNow = dueNow;
        this.newCharges = newCharges;
        this.percentOff = percentOff;
        this.periodStart = periodStart;
        this.promoCodeApplied = promoCodeApplied;
        this.proration = proration;
        this.trialEnd = trialEnd;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="amount_off")
    public int getAmountOff() {
        return this.amountOff;
    }

    @JsonProperty(value="due_now")
    public int getDueNow() {
        return this.dueNow;
    }

    @JsonProperty(value="new_charges")
    public int getNewCharges() {
        return this.newCharges;
    }

    @JsonProperty(value="percent_off")
    public double getPercentOff() {
        return this.percentOff;
    }

    @JsonProperty(value="period_start")
    public OffsetDateTime getPeriodStart() {
        return this.periodStart;
    }

    @JsonProperty(value="promo_code_applied")
    public boolean getPromoCodeApplied() {
        return this.promoCodeApplied;
    }

    @JsonProperty(value="proration")
    public int getProration() {
        return this.proration;
    }

    @JsonProperty(value="trial_end")
    public Optional<OffsetDateTime> getTrialEnd() {
        return this.trialEnd;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof PreviewSubscriptionChangeResponseData && this.equalTo((PreviewSubscriptionChangeResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewSubscriptionChangeResponseData other) {
        return this.amountOff == other.amountOff && this.dueNow == other.dueNow && this.newCharges == other.newCharges && this.percentOff == other.percentOff && this.periodStart.equals(other.periodStart) && this.promoCodeApplied == other.promoCodeApplied && this.proration == other.proration && this.trialEnd.equals(other.trialEnd);
    }

    public int hashCode() {
        return Objects.hash(this.amountOff, this.dueNow, this.newCharges, this.percentOff, this.periodStart, this.promoCodeApplied, this.proration, this.trialEnd);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountOffStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements AmountOffStage,
    DueNowStage,
    NewChargesStage,
    PercentOffStage,
    PeriodStartStage,
    PromoCodeAppliedStage,
    ProrationStage,
    _FinalStage {
        private int amountOff;
        private int dueNow;
        private int newCharges;
        private double percentOff;
        private OffsetDateTime periodStart;
        private boolean promoCodeApplied;
        private int proration;
        private Optional<OffsetDateTime> trialEnd = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(PreviewSubscriptionChangeResponseData other) {
            this.amountOff(other.getAmountOff());
            this.dueNow(other.getDueNow());
            this.newCharges(other.getNewCharges());
            this.percentOff(other.getPercentOff());
            this.periodStart(other.getPeriodStart());
            this.promoCodeApplied(other.getPromoCodeApplied());
            this.proration(other.getProration());
            this.trialEnd(other.getTrialEnd());
            return this;
        }

        @Override
        @JsonSetter(value="amount_off")
        public DueNowStage amountOff(int amountOff) {
            this.amountOff = amountOff;
            return this;
        }

        @Override
        @JsonSetter(value="due_now")
        public NewChargesStage dueNow(int dueNow) {
            this.dueNow = dueNow;
            return this;
        }

        @Override
        @JsonSetter(value="new_charges")
        public PercentOffStage newCharges(int newCharges) {
            this.newCharges = newCharges;
            return this;
        }

        @Override
        @JsonSetter(value="percent_off")
        public PeriodStartStage percentOff(double percentOff) {
            this.percentOff = percentOff;
            return this;
        }

        @Override
        @JsonSetter(value="period_start")
        public PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime periodStart) {
            this.periodStart = Objects.requireNonNull(periodStart, "periodStart must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="promo_code_applied")
        public ProrationStage promoCodeApplied(boolean promoCodeApplied) {
            this.promoCodeApplied = promoCodeApplied;
            return this;
        }

        @Override
        @JsonSetter(value="proration")
        public _FinalStage proration(int proration) {
            this.proration = proration;
            return this;
        }

        @Override
        public _FinalStage trialEnd(OffsetDateTime trialEnd) {
            this.trialEnd = Optional.ofNullable(trialEnd);
            return this;
        }

        @Override
        @JsonSetter(value="trial_end", nulls=Nulls.SKIP)
        public _FinalStage trialEnd(Optional<OffsetDateTime> trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        @Override
        public PreviewSubscriptionChangeResponseData build() {
            return new PreviewSubscriptionChangeResponseData(this.amountOff, this.dueNow, this.newCharges, this.percentOff, this.periodStart, this.promoCodeApplied, this.proration, this.trialEnd, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public PreviewSubscriptionChangeResponseData build();

        public _FinalStage trialEnd(Optional<OffsetDateTime> var1);

        public _FinalStage trialEnd(OffsetDateTime var1);
    }

    public static interface ProrationStage {
        public _FinalStage proration(int var1);
    }

    public static interface PromoCodeAppliedStage {
        public ProrationStage promoCodeApplied(boolean var1);
    }

    public static interface PeriodStartStage {
        public PromoCodeAppliedStage periodStart(@NotNull OffsetDateTime var1);
    }

    public static interface PercentOffStage {
        public PeriodStartStage percentOff(double var1);
    }

    public static interface NewChargesStage {
        public PercentOffStage newCharges(int var1);
    }

    public static interface DueNowStage {
        public NewChargesStage dueNow(int var1);
    }

    public static interface AmountOffStage {
        public DueNowStage amountOff(int var1);

        public Builder from(PreviewSubscriptionChangeResponseData var1);
    }
}

