/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class StripeEmbedInfo {
    private final String publishableKey;
    private final Optional<String> setupIntentClientSecret;
    private final Map<String, Object> additionalProperties;

    private StripeEmbedInfo(String publishableKey, Optional<String> setupIntentClientSecret, Map<String, Object> additionalProperties) {
        this.publishableKey = publishableKey;
        this.setupIntentClientSecret = setupIntentClientSecret;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="publishable_key")
    public String getPublishableKey() {
        return this.publishableKey;
    }

    @JsonProperty(value="setup_intent_client_secret")
    public Optional<String> getSetupIntentClientSecret() {
        return this.setupIntentClientSecret;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof StripeEmbedInfo && this.equalTo((StripeEmbedInfo)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StripeEmbedInfo other) {
        return this.publishableKey.equals(other.publishableKey) && this.setupIntentClientSecret.equals(other.setupIntentClientSecret);
    }

    public int hashCode() {
        return Objects.hash(this.publishableKey, this.setupIntentClientSecret);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PublishableKeyStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements PublishableKeyStage,
    _FinalStage {
        private String publishableKey;
        private Optional<String> setupIntentClientSecret = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(StripeEmbedInfo other) {
            this.publishableKey(other.getPublishableKey());
            this.setupIntentClientSecret(other.getSetupIntentClientSecret());
            return this;
        }

        @Override
        @JsonSetter(value="publishable_key")
        public _FinalStage publishableKey(@NotNull String publishableKey) {
            this.publishableKey = Objects.requireNonNull(publishableKey, "publishableKey must not be null");
            return this;
        }

        @Override
        public _FinalStage setupIntentClientSecret(String setupIntentClientSecret) {
            this.setupIntentClientSecret = Optional.ofNullable(setupIntentClientSecret);
            return this;
        }

        @Override
        @JsonSetter(value="setup_intent_client_secret", nulls=Nulls.SKIP)
        public _FinalStage setupIntentClientSecret(Optional<String> setupIntentClientSecret) {
            this.setupIntentClientSecret = setupIntentClientSecret;
            return this;
        }

        @Override
        public StripeEmbedInfo build() {
            return new StripeEmbedInfo(this.publishableKey, this.setupIntentClientSecret, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public StripeEmbedInfo build();

        public _FinalStage setupIntentClientSecret(Optional<String> var1);

        public _FinalStage setupIntentClientSecret(String var1);
    }

    public static interface PublishableKeyStage {
        public _FinalStage publishableKey(@NotNull String var1);

        public Builder from(StripeEmbedInfo var1);
    }
}

