/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class TemporaryAccessTokenResponseData {
    private final String apiKeyId;
    private final OffsetDateTime createdAt;
    private final String environmentId;
    private final OffsetDateTime expiredAt;
    private final String id;
    private final String resourceType;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private TemporaryAccessTokenResponseData(String apiKeyId, OffsetDateTime createdAt, String environmentId, OffsetDateTime expiredAt, String id, String resourceType, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.apiKeyId = apiKeyId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.expiredAt = expiredAt;
        this.id = id;
        this.resourceType = resourceType;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="api_key_id")
    public String getApiKeyId() {
        return this.apiKeyId;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="expired_at")
    public OffsetDateTime getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="resource_type")
    public String getResourceType() {
        return this.resourceType;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof TemporaryAccessTokenResponseData && this.equalTo((TemporaryAccessTokenResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TemporaryAccessTokenResponseData other) {
        return this.apiKeyId.equals(other.apiKeyId) && this.createdAt.equals(other.createdAt) && this.environmentId.equals(other.environmentId) && this.expiredAt.equals(other.expiredAt) && this.id.equals(other.id) && this.resourceType.equals(other.resourceType) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.apiKeyId, this.createdAt, this.environmentId, this.expiredAt, this.id, this.resourceType, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ApiKeyIdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements ApiKeyIdStage,
    CreatedAtStage,
    EnvironmentIdStage,
    ExpiredAtStage,
    IdStage,
    ResourceTypeStage,
    UpdatedAtStage,
    _FinalStage {
        private String apiKeyId;
        private OffsetDateTime createdAt;
        private String environmentId;
        private OffsetDateTime expiredAt;
        private String id;
        private String resourceType;
        private OffsetDateTime updatedAt;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(TemporaryAccessTokenResponseData other) {
            this.apiKeyId(other.getApiKeyId());
            this.createdAt(other.getCreatedAt());
            this.environmentId(other.getEnvironmentId());
            this.expiredAt(other.getExpiredAt());
            this.id(other.getId());
            this.resourceType(other.getResourceType());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="api_key_id")
        public CreatedAtStage apiKeyId(@NotNull String apiKeyId) {
            this.apiKeyId = Objects.requireNonNull(apiKeyId, "apiKeyId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public ExpiredAtStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="expired_at")
        public IdStage expiredAt(@NotNull OffsetDateTime expiredAt) {
            this.expiredAt = Objects.requireNonNull(expiredAt, "expiredAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public ResourceTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="resource_type")
        public UpdatedAtStage resourceType(@NotNull String resourceType) {
            this.resourceType = Objects.requireNonNull(resourceType, "resourceType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public TemporaryAccessTokenResponseData build() {
            return new TemporaryAccessTokenResponseData(this.apiKeyId, this.createdAt, this.environmentId, this.expiredAt, this.id, this.resourceType, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public TemporaryAccessTokenResponseData build();
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface ResourceTypeStage {
        public UpdatedAtStage resourceType(@NotNull String var1);
    }

    public static interface IdStage {
        public ResourceTypeStage id(@NotNull String var1);
    }

    public static interface ExpiredAtStage {
        public IdStage expiredAt(@NotNull OffsetDateTime var1);
    }

    public static interface EnvironmentIdStage {
        public ExpiredAtStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);
    }

    public static interface ApiKeyIdStage {
        public CreatedAtStage apiKeyId(@NotNull String var1);

        public Builder from(TemporaryAccessTokenResponseData var1);
    }
}

