/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.CompanyMembershipDetailResponseData;
import com.schematic.api.types.EntityKeyDetailResponseData;
import com.schematic.api.types.EntityTraitDetailResponseData;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class UserDetailResponseData {
    private final List<CompanyMembershipDetailResponseData> companyMemberships;
    private final OffsetDateTime createdAt;
    private final List<EntityTraitDetailResponseData> entityTraits;
    private final String environmentId;
    private final String id;
    private final List<EntityKeyDetailResponseData> keys;
    private final Optional<OffsetDateTime> lastSeenAt;
    private final String name;
    private final Optional<Map<String, JsonNode>> traits;
    private final OffsetDateTime updatedAt;
    private final Map<String, Object> additionalProperties;

    private UserDetailResponseData(List<CompanyMembershipDetailResponseData> companyMemberships, OffsetDateTime createdAt, List<EntityTraitDetailResponseData> entityTraits, String environmentId, String id, List<EntityKeyDetailResponseData> keys, Optional<OffsetDateTime> lastSeenAt, String name, Optional<Map<String, JsonNode>> traits, OffsetDateTime updatedAt, Map<String, Object> additionalProperties) {
        this.companyMemberships = companyMemberships;
        this.createdAt = createdAt;
        this.entityTraits = entityTraits;
        this.environmentId = environmentId;
        this.id = id;
        this.keys = keys;
        this.lastSeenAt = lastSeenAt;
        this.name = name;
        this.traits = traits;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="company_memberships")
    public List<CompanyMembershipDetailResponseData> getCompanyMemberships() {
        return this.companyMemberships;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="entity_traits")
    public List<EntityTraitDetailResponseData> getEntityTraits() {
        return this.entityTraits;
    }

    @JsonProperty(value="environment_id")
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="keys")
    public List<EntityKeyDetailResponseData> getKeys() {
        return this.keys;
    }

    @JsonProperty(value="last_seen_at")
    public Optional<OffsetDateTime> getLastSeenAt() {
        return this.lastSeenAt;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="traits")
    public Optional<Map<String, JsonNode>> getTraits() {
        return this.traits;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof UserDetailResponseData && this.equalTo((UserDetailResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UserDetailResponseData other) {
        return this.companyMemberships.equals(other.companyMemberships) && this.createdAt.equals(other.createdAt) && this.entityTraits.equals(other.entityTraits) && this.environmentId.equals(other.environmentId) && this.id.equals(other.id) && this.keys.equals(other.keys) && this.lastSeenAt.equals(other.lastSeenAt) && this.name.equals(other.name) && this.traits.equals(other.traits) && this.updatedAt.equals(other.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.companyMemberships, this.createdAt, this.entityTraits, this.environmentId, this.id, this.keys, this.lastSeenAt, this.name, this.traits, this.updatedAt);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    EnvironmentIdStage,
    IdStage,
    NameStage,
    UpdatedAtStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String environmentId;
        private String id;
        private String name;
        private OffsetDateTime updatedAt;
        private Optional<Map<String, JsonNode>> traits = Optional.empty();
        private Optional<OffsetDateTime> lastSeenAt = Optional.empty();
        private List<EntityKeyDetailResponseData> keys = new ArrayList<EntityKeyDetailResponseData>();
        private List<EntityTraitDetailResponseData> entityTraits = new ArrayList<EntityTraitDetailResponseData>();
        private List<CompanyMembershipDetailResponseData> companyMemberships = new ArrayList<CompanyMembershipDetailResponseData>();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(UserDetailResponseData other) {
            this.companyMemberships(other.getCompanyMemberships());
            this.createdAt(other.getCreatedAt());
            this.entityTraits(other.getEntityTraits());
            this.environmentId(other.getEnvironmentId());
            this.id(other.getId());
            this.keys(other.getKeys());
            this.lastSeenAt(other.getLastSeenAt());
            this.name(other.getName());
            this.traits(other.getTraits());
            this.updatedAt(other.getUpdatedAt());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="name")
        public UpdatedAtStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        public _FinalStage traits(Map<String, JsonNode> traits) {
            this.traits = Optional.ofNullable(traits);
            return this;
        }

        @Override
        @JsonSetter(value="traits", nulls=Nulls.SKIP)
        public _FinalStage traits(Optional<Map<String, JsonNode>> traits) {
            this.traits = traits;
            return this;
        }

        @Override
        public _FinalStage lastSeenAt(OffsetDateTime lastSeenAt) {
            this.lastSeenAt = Optional.ofNullable(lastSeenAt);
            return this;
        }

        @Override
        @JsonSetter(value="last_seen_at", nulls=Nulls.SKIP)
        public _FinalStage lastSeenAt(Optional<OffsetDateTime> lastSeenAt) {
            this.lastSeenAt = lastSeenAt;
            return this;
        }

        @Override
        public _FinalStage addAllKeys(List<EntityKeyDetailResponseData> keys) {
            this.keys.addAll(keys);
            return this;
        }

        @Override
        public _FinalStage addKeys(EntityKeyDetailResponseData keys) {
            this.keys.add(keys);
            return this;
        }

        @Override
        @JsonSetter(value="keys", nulls=Nulls.SKIP)
        public _FinalStage keys(List<EntityKeyDetailResponseData> keys) {
            this.keys.clear();
            this.keys.addAll(keys);
            return this;
        }

        @Override
        public _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            this.entityTraits.addAll(entityTraits);
            return this;
        }

        @Override
        public _FinalStage addEntityTraits(EntityTraitDetailResponseData entityTraits) {
            this.entityTraits.add(entityTraits);
            return this;
        }

        @Override
        @JsonSetter(value="entity_traits", nulls=Nulls.SKIP)
        public _FinalStage entityTraits(List<EntityTraitDetailResponseData> entityTraits) {
            this.entityTraits.clear();
            this.entityTraits.addAll(entityTraits);
            return this;
        }

        @Override
        public _FinalStage addAllCompanyMemberships(List<CompanyMembershipDetailResponseData> companyMemberships) {
            this.companyMemberships.addAll(companyMemberships);
            return this;
        }

        @Override
        public _FinalStage addCompanyMemberships(CompanyMembershipDetailResponseData companyMemberships) {
            this.companyMemberships.add(companyMemberships);
            return this;
        }

        @Override
        @JsonSetter(value="company_memberships", nulls=Nulls.SKIP)
        public _FinalStage companyMemberships(List<CompanyMembershipDetailResponseData> companyMemberships) {
            this.companyMemberships.clear();
            this.companyMemberships.addAll(companyMemberships);
            return this;
        }

        @Override
        public UserDetailResponseData build() {
            return new UserDetailResponseData(this.companyMemberships, this.createdAt, this.entityTraits, this.environmentId, this.id, this.keys, this.lastSeenAt, this.name, this.traits, this.updatedAt, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public UserDetailResponseData build();

        public _FinalStage companyMemberships(List<CompanyMembershipDetailResponseData> var1);

        public _FinalStage addCompanyMemberships(CompanyMembershipDetailResponseData var1);

        public _FinalStage addAllCompanyMemberships(List<CompanyMembershipDetailResponseData> var1);

        public _FinalStage entityTraits(List<EntityTraitDetailResponseData> var1);

        public _FinalStage addEntityTraits(EntityTraitDetailResponseData var1);

        public _FinalStage addAllEntityTraits(List<EntityTraitDetailResponseData> var1);

        public _FinalStage keys(List<EntityKeyDetailResponseData> var1);

        public _FinalStage addKeys(EntityKeyDetailResponseData var1);

        public _FinalStage addAllKeys(List<EntityKeyDetailResponseData> var1);

        public _FinalStage lastSeenAt(Optional<OffsetDateTime> var1);

        public _FinalStage lastSeenAt(OffsetDateTime var1);

        public _FinalStage traits(Optional<Map<String, JsonNode>> var1);

        public _FinalStage traits(Map<String, JsonNode> var1);
    }

    public static interface UpdatedAtStage {
        public _FinalStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface NameStage {
        public UpdatedAtStage name(@NotNull String var1);
    }

    public static interface IdStage {
        public NameStage id(@NotNull String var1);
    }

    public static interface EnvironmentIdStage {
        public IdStage environmentId(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(UserDetailResponseData var1);
    }
}

