/*
 * Decompiled with CFR 0.152.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class WebhookEventResponseData {
    private final OffsetDateTime createdAt;
    private final String id;
    private final Optional<String> payload;
    private final String requestType;
    private final Optional<Integer> responseCode;
    private final Optional<OffsetDateTime> sentAt;
    private final String status;
    private final OffsetDateTime updatedAt;
    private final String webhookId;
    private final Map<String, Object> additionalProperties;

    private WebhookEventResponseData(OffsetDateTime createdAt, String id, Optional<String> payload, String requestType, Optional<Integer> responseCode, Optional<OffsetDateTime> sentAt, String status, OffsetDateTime updatedAt, String webhookId, Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.id = id;
        this.payload = payload;
        this.requestType = requestType;
        this.responseCode = responseCode;
        this.sentAt = sentAt;
        this.status = status;
        this.updatedAt = updatedAt;
        this.webhookId = webhookId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="created_at")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="payload")
    public Optional<String> getPayload() {
        return this.payload;
    }

    @JsonProperty(value="request_type")
    public String getRequestType() {
        return this.requestType;
    }

    @JsonProperty(value="response_code")
    public Optional<Integer> getResponseCode() {
        return this.responseCode;
    }

    @JsonProperty(value="sent_at")
    public Optional<OffsetDateTime> getSentAt() {
        return this.sentAt;
    }

    @JsonProperty(value="status")
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="updated_at")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="webhook_id")
    public String getWebhookId() {
        return this.webhookId;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof WebhookEventResponseData && this.equalTo((WebhookEventResponseData)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(WebhookEventResponseData other) {
        return this.createdAt.equals(other.createdAt) && this.id.equals(other.id) && this.payload.equals(other.payload) && this.requestType.equals(other.requestType) && this.responseCode.equals(other.responseCode) && this.sentAt.equals(other.sentAt) && this.status.equals(other.status) && this.updatedAt.equals(other.updatedAt) && this.webhookId.equals(other.webhookId);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.id, this.payload, this.requestType, this.responseCode, this.sentAt, this.status, this.updatedAt, this.webhookId);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements CreatedAtStage,
    IdStage,
    RequestTypeStage,
    StatusStage,
    UpdatedAtStage,
    WebhookIdStage,
    _FinalStage {
        private OffsetDateTime createdAt;
        private String id;
        private String requestType;
        private String status;
        private OffsetDateTime updatedAt;
        private String webhookId;
        private Optional<OffsetDateTime> sentAt = Optional.empty();
        private Optional<Integer> responseCode = Optional.empty();
        private Optional<String> payload = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(WebhookEventResponseData other) {
            this.createdAt(other.getCreatedAt());
            this.id(other.getId());
            this.payload(other.getPayload());
            this.requestType(other.getRequestType());
            this.responseCode(other.getResponseCode());
            this.sentAt(other.getSentAt());
            this.status(other.getStatus());
            this.updatedAt(other.getUpdatedAt());
            this.webhookId(other.getWebhookId());
            return this;
        }

        @Override
        @JsonSetter(value="created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public RequestTypeStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="request_type")
        public StatusStage requestType(@NotNull String requestType) {
            this.requestType = Objects.requireNonNull(requestType, "requestType must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="status")
        public UpdatedAtStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="updated_at")
        public WebhookIdStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="webhook_id")
        public _FinalStage webhookId(@NotNull String webhookId) {
            this.webhookId = Objects.requireNonNull(webhookId, "webhookId must not be null");
            return this;
        }

        @Override
        public _FinalStage sentAt(OffsetDateTime sentAt) {
            this.sentAt = Optional.ofNullable(sentAt);
            return this;
        }

        @Override
        @JsonSetter(value="sent_at", nulls=Nulls.SKIP)
        public _FinalStage sentAt(Optional<OffsetDateTime> sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        @Override
        public _FinalStage responseCode(Integer responseCode) {
            this.responseCode = Optional.ofNullable(responseCode);
            return this;
        }

        @Override
        @JsonSetter(value="response_code", nulls=Nulls.SKIP)
        public _FinalStage responseCode(Optional<Integer> responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        @Override
        public _FinalStage payload(String payload) {
            this.payload = Optional.ofNullable(payload);
            return this;
        }

        @Override
        @JsonSetter(value="payload", nulls=Nulls.SKIP)
        public _FinalStage payload(Optional<String> payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public WebhookEventResponseData build() {
            return new WebhookEventResponseData(this.createdAt, this.id, this.payload, this.requestType, this.responseCode, this.sentAt, this.status, this.updatedAt, this.webhookId, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public WebhookEventResponseData build();

        public _FinalStage payload(Optional<String> var1);

        public _FinalStage payload(String var1);

        public _FinalStage responseCode(Optional<Integer> var1);

        public _FinalStage responseCode(Integer var1);

        public _FinalStage sentAt(Optional<OffsetDateTime> var1);

        public _FinalStage sentAt(OffsetDateTime var1);
    }

    public static interface WebhookIdStage {
        public _FinalStage webhookId(@NotNull String var1);
    }

    public static interface UpdatedAtStage {
        public WebhookIdStage updatedAt(@NotNull OffsetDateTime var1);
    }

    public static interface StatusStage {
        public UpdatedAtStage status(@NotNull String var1);
    }

    public static interface RequestTypeStage {
        public StatusStage requestType(@NotNull String var1);
    }

    public static interface IdStage {
        public RequestTypeStage id(@NotNull String var1);
    }

    public static interface CreatedAtStage {
        public IdStage createdAt(@NotNull OffsetDateTime var1);

        public Builder from(WebhookEventResponseData var1);
    }
}

