/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.accounts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CountApiRequestsRequest.Builder.class)
public final class CountApiRequestsRequest {
    private final Optional<String> q;

    private final Optional<String> requestType;

    private final Optional<String> environmentId;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private CountApiRequestsRequest(
            Optional<String> q,
            Optional<String> requestType,
            Optional<String> environmentId,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.q = q;
        this.requestType = requestType;
        this.environmentId = environmentId;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    @JsonProperty("request_type")
    public Optional<String> getRequestType() {
        return requestType;
    }

    @JsonProperty("environment_id")
    public Optional<String> getEnvironmentId() {
        return environmentId;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CountApiRequestsRequest && equalTo((CountApiRequestsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountApiRequestsRequest other) {
        return q.equals(other.q)
                && requestType.equals(other.requestType)
                && environmentId.equals(other.environmentId)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.q, this.requestType, this.environmentId, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> q = Optional.empty();

        private Optional<String> requestType = Optional.empty();

        private Optional<String> environmentId = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CountApiRequestsRequest other) {
            q(other.getQ());
            requestType(other.getRequestType());
            environmentId(other.getEnvironmentId());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value = "request_type", nulls = Nulls.SKIP)
        public Builder requestType(Optional<String> requestType) {
            this.requestType = requestType;
            return this;
        }

        public Builder requestType(String requestType) {
            this.requestType = Optional.ofNullable(requestType);
            return this;
        }

        @JsonSetter(value = "environment_id", nulls = Nulls.SKIP)
        public Builder environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public CountApiRequestsRequest build() {
            return new CountApiRequestsRequest(q, requestType, environmentId, limit, offset, additionalProperties);
        }
    }
}
