/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.accounts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateApiKeyRequestBody.Builder.class)
public final class CreateApiKeyRequestBody {
    private final Optional<String> description;

    private final Optional<String> environmentId;

    private final String name;

    private final Map<String, Object> additionalProperties;

    private CreateApiKeyRequestBody(
            Optional<String> description,
            Optional<String> environmentId,
            String name,
            Map<String, Object> additionalProperties) {
        this.description = description;
        this.environmentId = environmentId;
        this.name = name;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @JsonProperty("environment_id")
    public Optional<String> getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateApiKeyRequestBody && equalTo((CreateApiKeyRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateApiKeyRequestBody other) {
        return description.equals(other.description)
                && environmentId.equals(other.environmentId)
                && name.equals(other.name);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.description, this.environmentId, this.name);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        _FinalStage name(@NotNull String name);

        Builder from(CreateApiKeyRequestBody other);
    }

    public interface _FinalStage {
        CreateApiKeyRequestBody build();

        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        _FinalStage environmentId(Optional<String> environmentId);

        _FinalStage environmentId(String environmentId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, _FinalStage {
        private String name;

        private Optional<String> environmentId = Optional.empty();

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateApiKeyRequestBody other) {
            description(other.getDescription());
            environmentId(other.getEnvironmentId());
            name(other.getName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "environment_id", nulls = Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public CreateApiKeyRequestBody build() {
            return new CreateApiKeyRequestBody(description, environmentId, name, additionalProperties);
        }
    }
}
