/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.accounts.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListApiKeysRequest.Builder.class)
public final class ListApiKeysRequest {
    private final Optional<String> environmentId;

    private final boolean requireEnvironment;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private ListApiKeysRequest(
            Optional<String> environmentId,
            boolean requireEnvironment,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.environmentId = environmentId;
        this.requireEnvironment = requireEnvironment;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("environment_id")
    public Optional<String> getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("require_environment")
    public boolean getRequireEnvironment() {
        return requireEnvironment;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListApiKeysRequest && equalTo((ListApiKeysRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListApiKeysRequest other) {
        return environmentId.equals(other.environmentId)
                && requireEnvironment == other.requireEnvironment
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.environmentId, this.requireEnvironment, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static RequireEnvironmentStage builder() {
        return new Builder();
    }

    public interface RequireEnvironmentStage {
        _FinalStage requireEnvironment(boolean requireEnvironment);

        Builder from(ListApiKeysRequest other);
    }

    public interface _FinalStage {
        ListApiKeysRequest build();

        _FinalStage environmentId(Optional<String> environmentId);

        _FinalStage environmentId(String environmentId);

        _FinalStage limit(Optional<Integer> limit);

        _FinalStage limit(Integer limit);

        _FinalStage offset(Optional<Integer> offset);

        _FinalStage offset(Integer offset);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements RequireEnvironmentStage, _FinalStage {
        private boolean requireEnvironment;

        private Optional<Integer> offset = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<String> environmentId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ListApiKeysRequest other) {
            environmentId(other.getEnvironmentId());
            requireEnvironment(other.getRequireEnvironment());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @java.lang.Override
        @JsonSetter("require_environment")
        public _FinalStage requireEnvironment(boolean requireEnvironment) {
            this.requireEnvironment = requireEnvironment;
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public _FinalStage offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public _FinalStage limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        @java.lang.Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "environment_id", nulls = Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @java.lang.Override
        public ListApiKeysRequest build() {
            return new ListApiKeysRequest(environmentId, requireEnvironment, limit, offset, additionalProperties);
        }
    }
}
