/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CountUsersRequest.Builder.class)
public final class CountUsersRequest {
    private final Optional<String> companyId;

    private final Optional<String> ids;

    private final Optional<String> planId;

    private final Optional<String> q;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private CountUsersRequest(
            Optional<String> companyId,
            Optional<String> ids,
            Optional<String> planId,
            Optional<String> q,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.ids = ids;
        this.planId = planId;
        this.q = q;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter users by company ID (starts with comp_)
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return Filter users by multiple user IDs (starts with user_)
     */
    @JsonProperty("ids")
    public Optional<String> getIds() {
        return ids;
    }

    /**
     * @return Filter users by plan ID (starts with plan_)
     */
    @JsonProperty("plan_id")
    public Optional<String> getPlanId() {
        return planId;
    }

    /**
     * @return Search for users by name, keys or string traits
     */
    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CountUsersRequest && equalTo((CountUsersRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountUsersRequest other) {
        return companyId.equals(other.companyId)
                && ids.equals(other.ids)
                && planId.equals(other.planId)
                && q.equals(other.q)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.ids, this.planId, this.q, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();

        private Optional<String> ids = Optional.empty();

        private Optional<String> planId = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CountUsersRequest other) {
            companyId(other.getCompanyId());
            ids(other.getIds());
            planId(other.getPlanId());
            q(other.getQ());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<String> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        @JsonSetter(value = "plan_id", nulls = Nulls.SKIP)
        public Builder planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        public Builder planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public CountUsersRequest build() {
            return new CountUsersRequest(companyId, ids, planId, q, limit, offset, additionalProperties);
        }
    }
}
