/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.components.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PreviewComponentDataParams.Builder.class)
public final class PreviewComponentDataParams {
    private final Optional<String> companyId;

    private final Optional<String> componentId;

    private final Map<String, Object> additionalProperties;

    private PreviewComponentDataParams(
            Optional<String> companyId, Optional<String> componentId, Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.componentId = componentId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("component_id")
    public Optional<String> getComponentId() {
        return componentId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PreviewComponentDataParams && equalTo((PreviewComponentDataParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewComponentDataParams other) {
        return companyId.equals(other.companyId) && componentId.equals(other.componentId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.componentId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();

        private Optional<String> componentId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(PreviewComponentDataParams other) {
            companyId(other.getCompanyId());
            componentId(other.getComponentId());
            return this;
        }

        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value = "component_id", nulls = Nulls.SKIP)
        public Builder componentId(Optional<String> componentId) {
            this.componentId = componentId;
            return this;
        }

        public Builder componentId(String componentId) {
            this.componentId = Optional.ofNullable(componentId);
            return this;
        }

        public PreviewComponentDataParams build() {
            return new PreviewComponentDataParams(companyId, componentId, additionalProperties);
        }
    }
}
