/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.events.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = GetEventSummariesParams.Builder.class)
public final class GetEventSummariesParams {
    private final Optional<List<String>> eventSubtypes;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Optional<String> q;

    private final Map<String, Object> additionalProperties;

    private GetEventSummariesParams(
            Optional<List<String>> eventSubtypes,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Optional<String> q,
            Map<String, Object> additionalProperties) {
        this.eventSubtypes = eventSubtypes;
        this.limit = limit;
        this.offset = offset;
        this.q = q;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("event_subtypes")
    public Optional<List<String>> getEventSubtypes() {
        return eventSubtypes;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof GetEventSummariesParams && equalTo((GetEventSummariesParams) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(GetEventSummariesParams other) {
        return eventSubtypes.equals(other.eventSubtypes)
                && limit.equals(other.limit)
                && offset.equals(other.offset)
                && q.equals(other.q);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.eventSubtypes, this.limit, this.offset, this.q);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> eventSubtypes = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<String> q = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(GetEventSummariesParams other) {
            eventSubtypes(other.getEventSubtypes());
            limit(other.getLimit());
            offset(other.getOffset());
            q(other.getQ());
            return this;
        }

        @JsonSetter(value = "event_subtypes", nulls = Nulls.SKIP)
        public Builder eventSubtypes(Optional<List<String>> eventSubtypes) {
            this.eventSubtypes = eventSubtypes;
            return this;
        }

        public Builder eventSubtypes(List<String> eventSubtypes) {
            this.eventSubtypes = Optional.ofNullable(eventSubtypes);
            return this;
        }

        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        public GetEventSummariesParams build() {
            return new GetEventSummariesParams(eventSubtypes, limit, offset, q, additionalProperties);
        }
    }
}
