/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.plans.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.plans.types.CreatePlanRequestBodyPlanType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreatePlanRequestBody.Builder.class)
public final class CreatePlanRequestBody {
    private final String description;

    private final Optional<String> icon;

    private final String name;

    private final CreatePlanRequestBodyPlanType planType;

    private final Map<String, Object> additionalProperties;

    private CreatePlanRequestBody(
            String description,
            Optional<String> icon,
            String name,
            CreatePlanRequestBodyPlanType planType,
            Map<String, Object> additionalProperties) {
        this.description = description;
        this.icon = icon;
        this.name = name;
        this.planType = planType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("plan_type")
    public CreatePlanRequestBodyPlanType getPlanType() {
        return planType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreatePlanRequestBody && equalTo((CreatePlanRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreatePlanRequestBody other) {
        return description.equals(other.description)
                && icon.equals(other.icon)
                && name.equals(other.name)
                && planType.equals(other.planType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.description, this.icon, this.name, this.planType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DescriptionStage builder() {
        return new Builder();
    }

    public interface DescriptionStage {
        NameStage description(@NotNull String description);

        Builder from(CreatePlanRequestBody other);
    }

    public interface NameStage {
        PlanTypeStage name(@NotNull String name);
    }

    public interface PlanTypeStage {
        _FinalStage planType(@NotNull CreatePlanRequestBodyPlanType planType);
    }

    public interface _FinalStage {
        CreatePlanRequestBody build();

        _FinalStage icon(Optional<String> icon);

        _FinalStage icon(String icon);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DescriptionStage, NameStage, PlanTypeStage, _FinalStage {
        private String description;

        private String name;

        private CreatePlanRequestBodyPlanType planType;

        private Optional<String> icon = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreatePlanRequestBody other) {
            description(other.getDescription());
            icon(other.getIcon());
            name(other.getName());
            planType(other.getPlanType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public NameStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_type")
        public _FinalStage planType(@NotNull CreatePlanRequestBodyPlanType planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @java.lang.Override
        public CreatePlanRequestBody build() {
            return new CreatePlanRequestBody(description, icon, name, planType, additionalProperties);
        }
    }
}
