/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = AudienceRequestBody.Builder.class)
public final class AudienceRequestBody {
    private final List<CreateOrUpdateConditionGroupRequestBody> conditionGroups;

    private final List<CreateOrUpdateConditionRequestBody> conditions;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Optional<String> q;

    private final Map<String, Object> additionalProperties;

    private AudienceRequestBody(
            List<CreateOrUpdateConditionGroupRequestBody> conditionGroups,
            List<CreateOrUpdateConditionRequestBody> conditions,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Optional<String> q,
            Map<String, Object> additionalProperties) {
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.limit = limit;
        this.offset = offset;
        this.q = q;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("condition_groups")
    public List<CreateOrUpdateConditionGroupRequestBody> getConditionGroups() {
        return conditionGroups;
    }

    @JsonProperty("conditions")
    public List<CreateOrUpdateConditionRequestBody> getConditions() {
        return conditions;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof AudienceRequestBody && equalTo((AudienceRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(AudienceRequestBody other) {
        return conditionGroups.equals(other.conditionGroups)
                && conditions.equals(other.conditions)
                && limit.equals(other.limit)
                && offset.equals(other.offset)
                && q.equals(other.q);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.conditionGroups, this.conditions, this.limit, this.offset, this.q);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<CreateOrUpdateConditionGroupRequestBody> conditionGroups = new ArrayList<>();

        private List<CreateOrUpdateConditionRequestBody> conditions = new ArrayList<>();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        private Optional<String> q = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(AudienceRequestBody other) {
            conditionGroups(other.getConditionGroups());
            conditions(other.getConditions());
            limit(other.getLimit());
            offset(other.getOffset());
            q(other.getQ());
            return this;
        }

        @JsonSetter(value = "condition_groups", nulls = Nulls.SKIP)
        public Builder conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.clear();
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        public Builder addConditionGroups(CreateOrUpdateConditionGroupRequestBody conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        public Builder addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.addAll(conditionGroups);
            return this;
        }

        @JsonSetter(value = "conditions", nulls = Nulls.SKIP)
        public Builder conditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.clear();
            this.conditions.addAll(conditions);
            return this;
        }

        public Builder addConditions(CreateOrUpdateConditionRequestBody conditions) {
            this.conditions.add(conditions);
            return this;
        }

        public Builder addAllConditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.addAll(conditions);
            return this;
        }

        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        public AudienceRequestBody build() {
            return new AudienceRequestBody(conditionGroups, conditions, limit, offset, q, additionalProperties);
        }
    }
}
