/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingMeterResponseData.Builder.class)
public final class BillingMeterResponseData {
    private final String dispalyName;

    private final String eventName;

    private final String eventPayloadKey;

    private final String externalPriceId;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private BillingMeterResponseData(
            String dispalyName,
            String eventName,
            String eventPayloadKey,
            String externalPriceId,
            String id,
            Map<String, Object> additionalProperties) {
        this.dispalyName = dispalyName;
        this.eventName = eventName;
        this.eventPayloadKey = eventPayloadKey;
        this.externalPriceId = externalPriceId;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("dispaly_name")
    public String getDispalyName() {
        return dispalyName;
    }

    @JsonProperty("event_name")
    public String getEventName() {
        return eventName;
    }

    @JsonProperty("event_payload_key")
    public String getEventPayloadKey() {
        return eventPayloadKey;
    }

    @JsonProperty("external_price_id")
    public String getExternalPriceId() {
        return externalPriceId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingMeterResponseData && equalTo((BillingMeterResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingMeterResponseData other) {
        return dispalyName.equals(other.dispalyName)
                && eventName.equals(other.eventName)
                && eventPayloadKey.equals(other.eventPayloadKey)
                && externalPriceId.equals(other.externalPriceId)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.dispalyName, this.eventName, this.eventPayloadKey, this.externalPriceId, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DispalyNameStage builder() {
        return new Builder();
    }

    public interface DispalyNameStage {
        EventNameStage dispalyName(@NotNull String dispalyName);

        Builder from(BillingMeterResponseData other);
    }

    public interface EventNameStage {
        EventPayloadKeyStage eventName(@NotNull String eventName);
    }

    public interface EventPayloadKeyStage {
        ExternalPriceIdStage eventPayloadKey(@NotNull String eventPayloadKey);
    }

    public interface ExternalPriceIdStage {
        IdStage externalPriceId(@NotNull String externalPriceId);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        BillingMeterResponseData build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements DispalyNameStage,
                    EventNameStage,
                    EventPayloadKeyStage,
                    ExternalPriceIdStage,
                    IdStage,
                    _FinalStage {
        private String dispalyName;

        private String eventName;

        private String eventPayloadKey;

        private String externalPriceId;

        private String id;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingMeterResponseData other) {
            dispalyName(other.getDispalyName());
            eventName(other.getEventName());
            eventPayloadKey(other.getEventPayloadKey());
            externalPriceId(other.getExternalPriceId());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("dispaly_name")
        public EventNameStage dispalyName(@NotNull String dispalyName) {
            this.dispalyName = Objects.requireNonNull(dispalyName, "dispalyName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("event_name")
        public EventPayloadKeyStage eventName(@NotNull String eventName) {
            this.eventName = Objects.requireNonNull(eventName, "eventName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("event_payload_key")
        public ExternalPriceIdStage eventPayloadKey(@NotNull String eventPayloadKey) {
            this.eventPayloadKey = Objects.requireNonNull(eventPayloadKey, "eventPayloadKey must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_price_id")
        public IdStage externalPriceId(@NotNull String externalPriceId) {
            this.externalPriceId = Objects.requireNonNull(externalPriceId, "externalPriceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public BillingMeterResponseData build() {
            return new BillingMeterResponseData(
                    dispalyName, eventName, eventPayloadKey, externalPriceId, id, additionalProperties);
        }
    }
}
