/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingPriceView.Builder.class)
public final class BillingPriceView {
    private final OffsetDateTime createdAt;

    private final String currency;

    private final String id;

    private final String interval;

    private final boolean isActive;

    private final Optional<String> meterId;

    private final int price;

    private final String priceExternalId;

    private final String priceId;

    private final String productExternalId;

    private final String productId;

    private final String productName;

    private final OffsetDateTime updatedAt;

    private final String usageType;

    private final Map<String, Object> additionalProperties;

    private BillingPriceView(
            OffsetDateTime createdAt,
            String currency,
            String id,
            String interval,
            boolean isActive,
            Optional<String> meterId,
            int price,
            String priceExternalId,
            String priceId,
            String productExternalId,
            String productId,
            String productName,
            OffsetDateTime updatedAt,
            String usageType,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.currency = currency;
        this.id = id;
        this.interval = interval;
        this.isActive = isActive;
        this.meterId = meterId;
        this.price = price;
        this.priceExternalId = priceExternalId;
        this.priceId = priceId;
        this.productExternalId = productExternalId;
        this.productId = productId;
        this.productName = productName;
        this.updatedAt = updatedAt;
        this.usageType = usageType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("is_active")
    public boolean getIsActive() {
        return isActive;
    }

    @JsonProperty("meter_id")
    public Optional<String> getMeterId() {
        return meterId;
    }

    @JsonProperty("price")
    public int getPrice() {
        return price;
    }

    @JsonProperty("price_external_id")
    public String getPriceExternalId() {
        return priceExternalId;
    }

    @JsonProperty("price_id")
    public String getPriceId() {
        return priceId;
    }

    @JsonProperty("product_external_id")
    public String getProductExternalId() {
        return productExternalId;
    }

    @JsonProperty("product_id")
    public String getProductId() {
        return productId;
    }

    @JsonProperty("product_name")
    public String getProductName() {
        return productName;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("usage_type")
    public String getUsageType() {
        return usageType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingPriceView && equalTo((BillingPriceView) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingPriceView other) {
        return createdAt.equals(other.createdAt)
                && currency.equals(other.currency)
                && id.equals(other.id)
                && interval.equals(other.interval)
                && isActive == other.isActive
                && meterId.equals(other.meterId)
                && price == other.price
                && priceExternalId.equals(other.priceExternalId)
                && priceId.equals(other.priceId)
                && productExternalId.equals(other.productExternalId)
                && productId.equals(other.productId)
                && productName.equals(other.productName)
                && updatedAt.equals(other.updatedAt)
                && usageType.equals(other.usageType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt,
                this.currency,
                this.id,
                this.interval,
                this.isActive,
                this.meterId,
                this.price,
                this.priceExternalId,
                this.priceId,
                this.productExternalId,
                this.productId,
                this.productName,
                this.updatedAt,
                this.usageType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        CurrencyStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(BillingPriceView other);
    }

    public interface CurrencyStage {
        IdStage currency(@NotNull String currency);
    }

    public interface IdStage {
        IntervalStage id(@NotNull String id);
    }

    public interface IntervalStage {
        IsActiveStage interval(@NotNull String interval);
    }

    public interface IsActiveStage {
        PriceStage isActive(boolean isActive);
    }

    public interface PriceStage {
        PriceExternalIdStage price(int price);
    }

    public interface PriceExternalIdStage {
        PriceIdStage priceExternalId(@NotNull String priceExternalId);
    }

    public interface PriceIdStage {
        ProductExternalIdStage priceId(@NotNull String priceId);
    }

    public interface ProductExternalIdStage {
        ProductIdStage productExternalId(@NotNull String productExternalId);
    }

    public interface ProductIdStage {
        ProductNameStage productId(@NotNull String productId);
    }

    public interface ProductNameStage {
        UpdatedAtStage productName(@NotNull String productName);
    }

    public interface UpdatedAtStage {
        UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface UsageTypeStage {
        _FinalStage usageType(@NotNull String usageType);
    }

    public interface _FinalStage {
        BillingPriceView build();

        _FinalStage meterId(Optional<String> meterId);

        _FinalStage meterId(String meterId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    CurrencyStage,
                    IdStage,
                    IntervalStage,
                    IsActiveStage,
                    PriceStage,
                    PriceExternalIdStage,
                    PriceIdStage,
                    ProductExternalIdStage,
                    ProductIdStage,
                    ProductNameStage,
                    UpdatedAtStage,
                    UsageTypeStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String currency;

        private String id;

        private String interval;

        private boolean isActive;

        private int price;

        private String priceExternalId;

        private String priceId;

        private String productExternalId;

        private String productId;

        private String productName;

        private OffsetDateTime updatedAt;

        private String usageType;

        private Optional<String> meterId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingPriceView other) {
            createdAt(other.getCreatedAt());
            currency(other.getCurrency());
            id(other.getId());
            interval(other.getInterval());
            isActive(other.getIsActive());
            meterId(other.getMeterId());
            price(other.getPrice());
            priceExternalId(other.getPriceExternalId());
            priceId(other.getPriceId());
            productExternalId(other.getProductExternalId());
            productId(other.getProductId());
            productName(other.getProductName());
            updatedAt(other.getUpdatedAt());
            usageType(other.getUsageType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CurrencyStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public IdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public IsActiveStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_active")
        public PriceStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public PriceExternalIdStage price(int price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_external_id")
        public PriceIdStage priceExternalId(@NotNull String priceExternalId) {
            this.priceExternalId = Objects.requireNonNull(priceExternalId, "priceExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_id")
        public ProductExternalIdStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_external_id")
        public ProductIdStage productExternalId(@NotNull String productExternalId) {
            this.productExternalId = Objects.requireNonNull(productExternalId, "productExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_id")
        public ProductNameStage productId(@NotNull String productId) {
            this.productId = Objects.requireNonNull(productId, "productId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_name")
        public UpdatedAtStage productName(@NotNull String productName) {
            this.productName = Objects.requireNonNull(productName, "productName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public UsageTypeStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("usage_type")
        public _FinalStage usageType(@NotNull String usageType) {
            this.usageType = Objects.requireNonNull(usageType, "usageType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage meterId(String meterId) {
            this.meterId = Optional.ofNullable(meterId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "meter_id", nulls = Nulls.SKIP)
        public _FinalStage meterId(Optional<String> meterId) {
            this.meterId = meterId;
            return this;
        }

        @java.lang.Override
        public BillingPriceView build() {
            return new BillingPriceView(
                    createdAt,
                    currency,
                    id,
                    interval,
                    isActive,
                    meterId,
                    price,
                    priceExternalId,
                    priceId,
                    productExternalId,
                    productId,
                    productName,
                    updatedAt,
                    usageType,
                    additionalProperties);
        }
    }
}
