/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.schematic.api.core.ObjectMappers;
import java.io.IOException;
import java.util.Objects;

@JsonDeserialize(using = EventBody.Deserializer.class)
public final class EventBody {
    private final Object value;

    private final int type;

    private EventBody(Object value, int type) {
        this.value = value;
        this.type = type;
    }

    @JsonValue
    public Object get() {
        return this.value;
    }

    public <T> T visit(Visitor<T> visitor) {
        if (this.type == 0) {
            return visitor.visit((EventBodyTrack) this.value);
        } else if (this.type == 1) {
            return visitor.visit((EventBodyFlagCheck) this.value);
        } else if (this.type == 2) {
            return visitor.visit((EventBodyIdentify) this.value);
        }
        throw new IllegalStateException("Failed to visit value. This should never happen.");
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EventBody && equalTo((EventBody) other);
    }

    private boolean equalTo(EventBody other) {
        return value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.value);
    }

    @java.lang.Override
    public String toString() {
        return this.value.toString();
    }

    public static EventBody of(EventBodyTrack value) {
        return new EventBody(value, 0);
    }

    public static EventBody of(EventBodyFlagCheck value) {
        return new EventBody(value, 1);
    }

    public static EventBody of(EventBodyIdentify value) {
        return new EventBody(value, 2);
    }

    public interface Visitor<T> {
        T visit(EventBodyTrack value);

        T visit(EventBodyFlagCheck value);

        T visit(EventBodyIdentify value);
    }

    static final class Deserializer extends StdDeserializer<EventBody> {
        Deserializer() {
            super(EventBody.class);
        }

        @java.lang.Override
        public EventBody deserialize(JsonParser p, DeserializationContext context) throws IOException {
            Object value = p.readValueAs(Object.class);
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, EventBodyTrack.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, EventBodyFlagCheck.class));
            } catch (IllegalArgumentException e) {
            }
            try {
                return of(ObjectMappers.JSON_MAPPER.convertValue(value, EventBodyIdentify.class));
            } catch (IllegalArgumentException e) {
            }
            throw new JsonParseException(p, "Failed to deserialize");
        }
    }
}
