/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = EventResponseData.Builder.class)
public final class EventResponseData {
    private final Optional<String> apiKey;

    private final Map<String, JsonNode> body;

    private final String bodyPreview;

    private final OffsetDateTime capturedAt;

    private final Optional<String> companyId;

    private final Optional<OffsetDateTime> enrichedAt;

    private final Optional<String> environmentId;

    private final Optional<String> errorMessage;

    private final List<String> featureIds;

    private final String id;

    private final Optional<OffsetDateTime> loadedAt;

    private final Optional<OffsetDateTime> processedAt;

    private final int quantity;

    private final Optional<OffsetDateTime> sentAt;

    private final String status;

    private final Optional<String> subtype;

    private final String type;

    private final OffsetDateTime updatedAt;

    private final Optional<String> userId;

    private final Map<String, Object> additionalProperties;

    private EventResponseData(
            Optional<String> apiKey,
            Map<String, JsonNode> body,
            String bodyPreview,
            OffsetDateTime capturedAt,
            Optional<String> companyId,
            Optional<OffsetDateTime> enrichedAt,
            Optional<String> environmentId,
            Optional<String> errorMessage,
            List<String> featureIds,
            String id,
            Optional<OffsetDateTime> loadedAt,
            Optional<OffsetDateTime> processedAt,
            int quantity,
            Optional<OffsetDateTime> sentAt,
            String status,
            Optional<String> subtype,
            String type,
            OffsetDateTime updatedAt,
            Optional<String> userId,
            Map<String, Object> additionalProperties) {
        this.apiKey = apiKey;
        this.body = body;
        this.bodyPreview = bodyPreview;
        this.capturedAt = capturedAt;
        this.companyId = companyId;
        this.enrichedAt = enrichedAt;
        this.environmentId = environmentId;
        this.errorMessage = errorMessage;
        this.featureIds = featureIds;
        this.id = id;
        this.loadedAt = loadedAt;
        this.processedAt = processedAt;
        this.quantity = quantity;
        this.sentAt = sentAt;
        this.status = status;
        this.subtype = subtype;
        this.type = type;
        this.updatedAt = updatedAt;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("api_key")
    public Optional<String> getApiKey() {
        return apiKey;
    }

    @JsonProperty("body")
    public Map<String, JsonNode> getBody() {
        return body;
    }

    @JsonProperty("body_preview")
    public String getBodyPreview() {
        return bodyPreview;
    }

    @JsonProperty("captured_at")
    public OffsetDateTime getCapturedAt() {
        return capturedAt;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("enriched_at")
    public Optional<OffsetDateTime> getEnrichedAt() {
        return enrichedAt;
    }

    @JsonProperty("environment_id")
    public Optional<String> getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("error_message")
    public Optional<String> getErrorMessage() {
        return errorMessage;
    }

    @JsonProperty("feature_ids")
    public List<String> getFeatureIds() {
        return featureIds;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("loaded_at")
    public Optional<OffsetDateTime> getLoadedAt() {
        return loadedAt;
    }

    @JsonProperty("processed_at")
    public Optional<OffsetDateTime> getProcessedAt() {
        return processedAt;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @JsonProperty("sent_at")
    public Optional<OffsetDateTime> getSentAt() {
        return sentAt;
    }

    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    @JsonProperty("subtype")
    public Optional<String> getSubtype() {
        return subtype;
    }

    @JsonProperty("type")
    public String getType() {
        return type;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("user_id")
    public Optional<String> getUserId() {
        return userId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EventResponseData && equalTo((EventResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EventResponseData other) {
        return apiKey.equals(other.apiKey)
                && body.equals(other.body)
                && bodyPreview.equals(other.bodyPreview)
                && capturedAt.equals(other.capturedAt)
                && companyId.equals(other.companyId)
                && enrichedAt.equals(other.enrichedAt)
                && environmentId.equals(other.environmentId)
                && errorMessage.equals(other.errorMessage)
                && featureIds.equals(other.featureIds)
                && id.equals(other.id)
                && loadedAt.equals(other.loadedAt)
                && processedAt.equals(other.processedAt)
                && quantity == other.quantity
                && sentAt.equals(other.sentAt)
                && status.equals(other.status)
                && subtype.equals(other.subtype)
                && type.equals(other.type)
                && updatedAt.equals(other.updatedAt)
                && userId.equals(other.userId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.apiKey,
                this.body,
                this.bodyPreview,
                this.capturedAt,
                this.companyId,
                this.enrichedAt,
                this.environmentId,
                this.errorMessage,
                this.featureIds,
                this.id,
                this.loadedAt,
                this.processedAt,
                this.quantity,
                this.sentAt,
                this.status,
                this.subtype,
                this.type,
                this.updatedAt,
                this.userId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BodyPreviewStage builder() {
        return new Builder();
    }

    public interface BodyPreviewStage {
        CapturedAtStage bodyPreview(@NotNull String bodyPreview);

        Builder from(EventResponseData other);
    }

    public interface CapturedAtStage {
        IdStage capturedAt(@NotNull OffsetDateTime capturedAt);
    }

    public interface IdStage {
        QuantityStage id(@NotNull String id);
    }

    public interface QuantityStage {
        StatusStage quantity(int quantity);
    }

    public interface StatusStage {
        TypeStage status(@NotNull String status);
    }

    public interface TypeStage {
        UpdatedAtStage type(@NotNull String type);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        EventResponseData build();

        _FinalStage apiKey(Optional<String> apiKey);

        _FinalStage apiKey(String apiKey);

        _FinalStage body(Map<String, JsonNode> body);

        _FinalStage putAllBody(Map<String, JsonNode> body);

        _FinalStage body(String key, JsonNode value);

        _FinalStage companyId(Optional<String> companyId);

        _FinalStage companyId(String companyId);

        _FinalStage enrichedAt(Optional<OffsetDateTime> enrichedAt);

        _FinalStage enrichedAt(OffsetDateTime enrichedAt);

        _FinalStage environmentId(Optional<String> environmentId);

        _FinalStage environmentId(String environmentId);

        _FinalStage errorMessage(Optional<String> errorMessage);

        _FinalStage errorMessage(String errorMessage);

        _FinalStage featureIds(List<String> featureIds);

        _FinalStage addFeatureIds(String featureIds);

        _FinalStage addAllFeatureIds(List<String> featureIds);

        _FinalStage loadedAt(Optional<OffsetDateTime> loadedAt);

        _FinalStage loadedAt(OffsetDateTime loadedAt);

        _FinalStage processedAt(Optional<OffsetDateTime> processedAt);

        _FinalStage processedAt(OffsetDateTime processedAt);

        _FinalStage sentAt(Optional<OffsetDateTime> sentAt);

        _FinalStage sentAt(OffsetDateTime sentAt);

        _FinalStage subtype(Optional<String> subtype);

        _FinalStage subtype(String subtype);

        _FinalStage userId(Optional<String> userId);

        _FinalStage userId(String userId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements BodyPreviewStage,
                    CapturedAtStage,
                    IdStage,
                    QuantityStage,
                    StatusStage,
                    TypeStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String bodyPreview;

        private OffsetDateTime capturedAt;

        private String id;

        private int quantity;

        private String status;

        private String type;

        private OffsetDateTime updatedAt;

        private Optional<String> userId = Optional.empty();

        private Optional<String> subtype = Optional.empty();

        private Optional<OffsetDateTime> sentAt = Optional.empty();

        private Optional<OffsetDateTime> processedAt = Optional.empty();

        private Optional<OffsetDateTime> loadedAt = Optional.empty();

        private List<String> featureIds = new ArrayList<>();

        private Optional<String> errorMessage = Optional.empty();

        private Optional<String> environmentId = Optional.empty();

        private Optional<OffsetDateTime> enrichedAt = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Map<String, JsonNode> body = new LinkedHashMap<>();

        private Optional<String> apiKey = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(EventResponseData other) {
            apiKey(other.getApiKey());
            body(other.getBody());
            bodyPreview(other.getBodyPreview());
            capturedAt(other.getCapturedAt());
            companyId(other.getCompanyId());
            enrichedAt(other.getEnrichedAt());
            environmentId(other.getEnvironmentId());
            errorMessage(other.getErrorMessage());
            featureIds(other.getFeatureIds());
            id(other.getId());
            loadedAt(other.getLoadedAt());
            processedAt(other.getProcessedAt());
            quantity(other.getQuantity());
            sentAt(other.getSentAt());
            status(other.getStatus());
            subtype(other.getSubtype());
            type(other.getType());
            updatedAt(other.getUpdatedAt());
            userId(other.getUserId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("body_preview")
        public CapturedAtStage bodyPreview(@NotNull String bodyPreview) {
            this.bodyPreview = Objects.requireNonNull(bodyPreview, "bodyPreview must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("captured_at")
        public IdStage capturedAt(@NotNull OffsetDateTime capturedAt) {
            this.capturedAt = Objects.requireNonNull(capturedAt, "capturedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public QuantityStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public StatusStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("status")
        public TypeStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("type")
        public UpdatedAtStage type(@NotNull String type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage userId(String userId) {
            this.userId = Optional.ofNullable(userId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "user_id", nulls = Nulls.SKIP)
        public _FinalStage userId(Optional<String> userId) {
            this.userId = userId;
            return this;
        }

        @java.lang.Override
        public _FinalStage subtype(String subtype) {
            this.subtype = Optional.ofNullable(subtype);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "subtype", nulls = Nulls.SKIP)
        public _FinalStage subtype(Optional<String> subtype) {
            this.subtype = subtype;
            return this;
        }

        @java.lang.Override
        public _FinalStage sentAt(OffsetDateTime sentAt) {
            this.sentAt = Optional.ofNullable(sentAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "sent_at", nulls = Nulls.SKIP)
        public _FinalStage sentAt(Optional<OffsetDateTime> sentAt) {
            this.sentAt = sentAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage processedAt(OffsetDateTime processedAt) {
            this.processedAt = Optional.ofNullable(processedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "processed_at", nulls = Nulls.SKIP)
        public _FinalStage processedAt(Optional<OffsetDateTime> processedAt) {
            this.processedAt = processedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage loadedAt(OffsetDateTime loadedAt) {
            this.loadedAt = Optional.ofNullable(loadedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "loaded_at", nulls = Nulls.SKIP)
        public _FinalStage loadedAt(Optional<OffsetDateTime> loadedAt) {
            this.loadedAt = loadedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllFeatureIds(List<String> featureIds) {
            this.featureIds.addAll(featureIds);
            return this;
        }

        @java.lang.Override
        public _FinalStage addFeatureIds(String featureIds) {
            this.featureIds.add(featureIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature_ids", nulls = Nulls.SKIP)
        public _FinalStage featureIds(List<String> featureIds) {
            this.featureIds.clear();
            this.featureIds.addAll(featureIds);
            return this;
        }

        @java.lang.Override
        public _FinalStage errorMessage(String errorMessage) {
            this.errorMessage = Optional.ofNullable(errorMessage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "error_message", nulls = Nulls.SKIP)
        public _FinalStage errorMessage(Optional<String> errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @java.lang.Override
        public _FinalStage environmentId(String environmentId) {
            this.environmentId = Optional.ofNullable(environmentId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "environment_id", nulls = Nulls.SKIP)
        public _FinalStage environmentId(Optional<String> environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @java.lang.Override
        public _FinalStage enrichedAt(OffsetDateTime enrichedAt) {
            this.enrichedAt = Optional.ofNullable(enrichedAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "enriched_at", nulls = Nulls.SKIP)
        public _FinalStage enrichedAt(Optional<OffsetDateTime> enrichedAt) {
            this.enrichedAt = enrichedAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public _FinalStage companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        @java.lang.Override
        public _FinalStage body(String key, JsonNode value) {
            this.body.put(key, value);
            return this;
        }

        @java.lang.Override
        public _FinalStage putAllBody(Map<String, JsonNode> body) {
            this.body.putAll(body);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "body", nulls = Nulls.SKIP)
        public _FinalStage body(Map<String, JsonNode> body) {
            this.body.clear();
            this.body.putAll(body);
            return this;
        }

        @java.lang.Override
        public _FinalStage apiKey(String apiKey) {
            this.apiKey = Optional.ofNullable(apiKey);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "api_key", nulls = Nulls.SKIP)
        public _FinalStage apiKey(Optional<String> apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @java.lang.Override
        public EventResponseData build() {
            return new EventResponseData(
                    apiKey,
                    body,
                    bodyPreview,
                    capturedAt,
                    companyId,
                    enrichedAt,
                    environmentId,
                    errorMessage,
                    featureIds,
                    id,
                    loadedAt,
                    processedAt,
                    quantity,
                    sentAt,
                    status,
                    subtype,
                    type,
                    updatedAt,
                    userId,
                    additionalProperties);
        }
    }
}
